package com.ekoapp.ekosdk.internal.usecase.comment

import com.amity.socialcloud.sdk.model.social.comment.AmityComment
import com.amity.socialcloud.sdk.social.data.comment.CommentRepository
import com.amity.socialcloud.sdk.social.domain.comment.CommentComposerUseCase
import io.reactivex.rxjava3.core.Single

internal class LatestCommentQueryUseCase {
    fun execute(
        referenceId: String,
        referenceType: String,
        isFilterByParentId: Boolean
    ): Single<AmityComment> {

        return CommentRepository().getLatestComment(referenceId, referenceType, isFilterByParentId)
            .map {
                CommentComposerUseCase().execute(it)
            }
    }
}