package com.ekoapp.ekosdk.internal.usecase.comment

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.api.social.comment.query.AmityCommentDataTypeFilter
import com.amity.socialcloud.sdk.api.social.comment.query.AmityCommentSortOption
import com.amity.socialcloud.sdk.model.social.comment.AmityComment
import com.amity.socialcloud.sdk.social.data.comment.CommentRepository
import com.amity.socialcloud.sdk.social.domain.comment.CommentComposerUseCase
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class CommentPagingDataUseCase {

    fun execute(
        referenceId: String,
        referenceType: String,
        isFilterByParentId: Boolean,
        parentId: String?,
        isDeleted: Boolean?,
        sortOption: AmityCommentSortOption,
        dataTypeFilter: AmityCommentDataTypeFilter?
    ): Flowable<PagingData<AmityComment>> {
        return CommentRepository().getCommentPagingData(
            referenceId,
            referenceType,
            isFilterByParentId,
            parentId,
            isDeleted,
            sortOption,
            dataTypeFilter
        ).map { pagingData ->
            pagingData.map(Executors.newSingleThreadExecutor()) { comment ->
                CommentComposerUseCase().execute(comment)
            }
        }
    }

}