package com.ekoapp.ekosdk.internal.data.converter

import androidx.room.TypeConverter
import com.amity.socialcloud.sdk.socket.util.EkoGson
import com.ekoapp.ekosdk.internal.api.dto.EkoMentioneesDto
import com.google.gson.reflect.TypeToken

class MentioneesConverter {

    @TypeConverter
    fun jsonToMentionees(json: String): List<EkoMentioneesDto> {
        return EkoGson.get().fromJson(json, object : TypeToken<List<EkoMentioneesDto>>() {}.type)
    }

    @TypeConverter
    fun mentioneesToJson(list: List<EkoMentioneesDto>): String {
        return EkoGson.get().toJson(list)
    }
}