package com.amity.socialcloud.sdk.social.data.story

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.entity.social.story.StoryEntity
import com.amity.socialcloud.sdk.model.social.story.AmityStory


internal class StoryModelMapper : ModelMapper<StoryEntity, AmityStory>() {

    override fun map(entity: StoryEntity): AmityStory {
        return AmityStory(
            storyId = entity.storyId,
            uniqueId = entity.uniqueId,
            targetType = AmityStory.TargetType.enumOf(entity.targetType),
            targetId = entity.targetId,
            state = AmityStory.State.enumOf(entity.syncState),
            metadata = entity.metadata,
            dataType = AmityStory.DataType.enumOf(entity.dataType),
            rawData = entity.data,
            rawStoryItems = entity.items,
            reactions = entity.reactions,
            reactionCount = entity.reactionCount,
            commentCount = entity.commentCount,
            flagCount = entity.flagCount,
            isDeleted = entity.isDeleted,
            expiresAt = entity.storyExpiresAt,
            createdAt = entity.getCreatedAt(),
            updatedAt = entity.getUpdatedAt(),
            path = entity.path,
            impression = entity.impression,
            reach = entity.reach,
            creatorId = entity.creatorId
        )
    }

}
