/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.common;

import com.amity.socialcloud.sdk.common.AmityObjectRepository;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.core.exception.EntityExpiredException;
import com.amity.socialcloud.sdk.core.exception.EntityNotFoundException;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.ekoapp.ekosdk.EkoObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000 \u0013*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0004:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0014\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bH&J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\b\u001a\u00020\tH&J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00102\u0006\u0010\b\u001a\u00020\tH\u0016J\u0017\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/amity/socialcloud/sdk/common/AmityObjectRepository;", "Entity", "Lcom/ekoapp/ekosdk/EkoObject;", "PublicModel", "", "()V", "fetchAndSave", "Lio/reactivex/rxjava3/core/Completable;", "objectId", "", "mapper", "Lcom/amity/socialcloud/sdk/common/ModelMapper;", "observe", "Lio/reactivex/rxjava3/core/Flowable;", "observeFromCache", "obtain", "Lio/reactivex/rxjava3/core/Single;", "queryFromCache", "(Ljava/lang/String;)Lcom/ekoapp/ekosdk/EkoObject;", "Companion", "amity-sdk_release"})
public abstract class AmityObjectRepository<Entity extends EkoObject, PublicModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int DEFAULT_PAGE_SIZE = 20;

    @NotNull
    public abstract Completable fetchAndSave(@NotNull String var1);

    @Nullable
    public abstract Entity queryFromCache(@NotNull String var1);

    @NotNull
    public abstract ModelMapper<Entity, PublicModel> mapper();

    @NotNull
    public abstract Flowable<Entity> observeFromCache(@NotNull String var1);

    @NotNull
    public Flowable<PublicModel> observe(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Flowable flowable = this.observeFromCache(objectId).map(new Function(this){
            final /* synthetic */ AmityObjectRepository<Entity, PublicModel> this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final PublicModel apply(@NotNull Entity it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.this$0.mapper().map(it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"open fun observe(objectI\u2026 mapper().map(it) }\n    }");
        return flowable;
    }

    @NotNull
    public Single<PublicModel> obtain(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        String TAG = "OTP2";
        Single single = Single.fromCallable(() -> AmityObjectRepository.obtain$lambda$0(TAG, this, objectId));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"fromCallable {\n         \u2026tFoundException\n        }");
        Single queryFromCacheSingle = single;
        Single single2 = queryFromCacheSingle.subscribeOn(Schedulers.io()).flatMap(new Function(TAG){
            final /* synthetic */ String $TAG;
            {
                this.$TAG = $TAG;
            }

            @NotNull
            public final SingleSource<? extends Entity> apply(@NotNull Entity it) {
                boolean isNotExpired;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                DateTime dateTime = ((EkoObject)it).getExpiresAt();
                boolean bl = dateTime != null ? dateTime.isAfterNow() : (isNotExpired = false);
                if (isNotExpired) {
                    AmityLog.INSTANCE.tag(this.$TAG).e("return cached data", new Object[0]);
                    return (SingleSource)Single.just(it);
                }
                return (SingleSource)Single.error((Throwable)EntityExpiredException.INSTANCE);
            }
        }).onErrorResumeNext(new Function(TAG, this, objectId, queryFromCacheSingle){
            final /* synthetic */ String $TAG;
            final /* synthetic */ AmityObjectRepository<Entity, PublicModel> this$0;
            final /* synthetic */ String $objectId;
            final /* synthetic */ Single<Entity> $queryFromCacheSingle;
            {
                this.$TAG = $TAG;
                this.this$0 = $receiver;
                this.$objectId = $objectId;
                this.$queryFromCacheSingle = $queryFromCacheSingle;
            }

            @NotNull
            public final SingleSource<? extends Entity> apply(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AmityLog.INSTANCE.tag(this.$TAG).e(String.valueOf(it.getMessage()), new Object[0]);
                if (Intrinsics.areEqual((Object)it, (Object)EntityNotFoundException.INSTANCE) || Intrinsics.areEqual((Object)it, (Object)EntityExpiredException.INSTANCE)) {
                    AmityLog.INSTANCE.tag(this.$TAG).e("fetching object from server", new Object[0]);
                    return (SingleSource)this.this$0.fetchAndSave(this.$objectId).andThen((SingleSource)Single.defer(() -> obtain.2.apply$lambda$0(this.$queryFromCacheSingle))).onErrorResumeNext((Function)obtain.2.INSTANCE);
                }
                return (SingleSource)Single.error((Throwable)it);
            }

            private static final SingleSource apply$lambda$0(Single $queryFromCacheSingle) {
                Intrinsics.checkNotNullParameter((Object)$queryFromCacheSingle, (String)"$queryFromCacheSingle");
                return (SingleSource)$queryFromCacheSingle;
            }
        }).map(new Function(this){
            final /* synthetic */ AmityObjectRepository<Entity, PublicModel> this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final PublicModel apply(@NotNull Entity it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.this$0.mapper().map(it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single2, (String)"Entity: EkoObject, Publi\u2026 mapper().map(it) }\n    }");
        return single2;
    }

    private static final EkoObject obtain$lambda$0(String $TAG, AmityObjectRepository this$0, String $objectId) {
        Intrinsics.checkNotNullParameter((Object)$TAG, (String)"$TAG");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$objectId, (String)"$objectId");
        AmityLog.INSTANCE.tag($TAG).e("query cached data", new Object[0]);
        Object Entity2 = this$0.queryFromCache($objectId);
        if (Entity2 == null) {
            throw EntityNotFoundException.INSTANCE;
        }
        return Entity2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/amity/socialcloud/sdk/common/AmityObjectRepository$Companion;", "", "()V", "DEFAULT_PAGE_SIZE", "", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

