package com.amity.socialcloud.sdk.social.domain.storytarget.get

import com.amity.socialcloud.sdk.common.AmityObjectRepository
import com.amity.socialcloud.sdk.entity.social.story.StoryTargetEntity
import com.amity.socialcloud.sdk.model.social.story.AmityStoryTarget
import com.amity.socialcloud.sdk.social.data.storytarget.StoryTargetRepository
import com.amity.socialcloud.sdk.social.domain.storytarget.composer.StoryTargetComposerUseCase
import com.ekoapp.ekosdk.internal.TombstoneModelType
import com.ekoapp.ekosdk.internal.usecase.LiveObjectUseCase


internal class StoryTargetLiveObjectUseCase : LiveObjectUseCase<StoryTargetEntity, AmityStoryTarget>() {

    override fun createRepository(): AmityObjectRepository<StoryTargetEntity, AmityStoryTarget> =
        StoryTargetRepository()

    override fun composeModel(model: AmityStoryTarget): AmityStoryTarget = StoryTargetComposerUseCase().execute(model)

    override fun tombstoneModelType(): TombstoneModelType = TombstoneModelType.STORY_TARGET

}