package com.amity.socialcloud.sdk.core.domain.ad.query

import com.amity.socialcloud.sdk.core.domain.ad.advertiser.GetAdvertiserUseCase
import com.amity.socialcloud.sdk.core.domain.file.ImageGetUseCase
import com.amity.socialcloud.sdk.model.core.ad.AmityNetworkAds

internal class NetworkAdsComposerUseCase {

    fun execute(networkAds: AmityNetworkAds): AmityNetworkAds {
        addLinkedObjects(networkAds)
        return networkAds
    }

    private fun addLinkedObjects(networkAds: AmityNetworkAds) {
        networkAds.getAds().forEach { ad ->
            ad.advertiser = GetAdvertiserUseCase().execute(ad.advertiserId)
            ad.image1_1FileId?.let {
                ad.image1_1 = ImageGetUseCase().execute(it)
            }
            ad.image9_16FileId?.let {
                ad.image9_16 = ImageGetUseCase().execute(it)
            }
        }
    }


}