package com.amity.socialcloud.sdk.api.chat.message.create

import com.amity.socialcloud.sdk.chat.domain.message.MessageCreateUseCase
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage
import com.amity.socialcloud.sdk.model.chat.message.AmityMessageAttachment
import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Completable

abstract class AmityMessageCreator internal constructor(
    private val subChannelId: String,
    private val parentId: String?,
    private val metadata: JsonObject? = null,
    private val tags: AmityTags = AmityTags(),
    private val mentionees: List<AmityMentioneeTarget> = emptyList(),
    private val attachment: AmityMessageAttachment? = null,
) {

    fun getTags(): AmityTags {
        return tags
    }

    abstract fun getData(): JsonObject

    abstract fun getDataType(): AmityMessage.DataType

    fun send(): Completable {
        return MessageCreateUseCase().execute(
            subChannelId = subChannelId,
            parentId = parentId,
            type = getDataType().apiKey,
            fileUri = (attachment as? AmityMessageAttachment.URL)?.uri,
            fileId = (attachment as? AmityMessageAttachment.FILE_ID)?.fileId,
            data = getData(),
            tags = tags,
            metadata = metadata,
            mentionees = mentionees
        )
    }

}