package com.amity.socialcloud.sdk.api.core.reaction

import com.amity.socialcloud.sdk.api.core.reaction.query.AmityReactionQuery
import com.amity.socialcloud.sdk.api.core.reaction.reference.AmityReactionReference
import com.amity.socialcloud.sdk.core.domain.reaction.ReactionAddUseCase
import com.amity.socialcloud.sdk.core.domain.reaction.ReactionRemoveUseCase
import io.reactivex.rxjava3.core.Completable

class AmityReactionRepository internal constructor() {
    
    /* begin_public_function
	  id: reaction.query
	  api_style: live_collection
	*/
    fun getReactions(reactionReference: AmityReactionReference): AmityReactionQuery.Builder {
        return AmityReactionQuery.Builder(reactionReference)
    }
    /* end_public_function */
    
    /* begin_public_function
	  id: reaction.add
	*/
    fun addReaction(reactionReference: AmityReactionReference, reactionName: String): Completable {
        return ReactionAddUseCase().execute(
            referenceType = reactionReference.referenceType,
            referenceId = reactionReference.referenceId,
            reactionName = reactionName
        )
    }
    /* end_public_function */
    
    /* begin_public_function
	  id: reaction.remove
	*/
    fun removeReaction(reactionReference: AmityReactionReference, reactionName: String): Completable {
        return ReactionRemoveUseCase().execute(
            referenceType = reactionReference.referenceType,
            referenceId = reactionReference.referenceId,
            reactionName = reactionName
        )
    }
    /* end_public_function */

}