/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.PinDao;
import com.ekoapp.ekosdk.internal.data.model.PinEntity;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;

public final class PinDao_Impl
extends PinDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<PinEntity> __insertionAdapterOfPinEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<PinEntity> __deletionAdapterOfPinEntity;
    private final EntityDeletionOrUpdateAdapter<PinEntity> __updateAdapterOfPinEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfUpdatePin;

    public PinDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPinEntity = new EntityInsertionAdapter<PinEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `pin` (`pinId`,`referenceId`,`referenceType`,`placement`,`targetId`,`targetType`,`pinnedBy`,`pinnedAt`,`lastPinsUpdatedAt`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, PinEntity value) {
                if (value.getPinId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPinId());
                }
                if (value.getReferenceId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getReferenceId());
                }
                if (value.getReferenceType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getReferenceType());
                }
                if (value.getPlacement() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getPlacement());
                }
                if (value.getTargetId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getTargetId());
                }
                if (value.getTargetType() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getTargetType());
                }
                if (value.getPinnedBy() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getPinnedBy());
                }
                String _tmp = PinDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getPinnedAt());
                if (_tmp == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp);
                }
                String _tmp_1 = PinDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLastPinsUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_1);
                }
                String _tmp_2 = PinDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_2);
                }
                String _tmp_3 = PinDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_3);
                }
                String _tmp_4 = PinDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_4);
                }
            }
        };
        this.__deletionAdapterOfPinEntity = new EntityDeletionOrUpdateAdapter<PinEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `pin` WHERE `pinId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, PinEntity value) {
                if (value.getPinId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPinId());
                }
            }
        };
        this.__updateAdapterOfPinEntity = new EntityDeletionOrUpdateAdapter<PinEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `pin` SET `pinId` = ?,`referenceId` = ?,`referenceType` = ?,`placement` = ?,`targetId` = ?,`targetType` = ?,`pinnedBy` = ?,`pinnedAt` = ?,`lastPinsUpdatedAt` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `pinId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, PinEntity value) {
                if (value.getPinId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPinId());
                }
                if (value.getReferenceId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getReferenceId());
                }
                if (value.getReferenceType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getReferenceType());
                }
                if (value.getPlacement() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getPlacement());
                }
                if (value.getTargetId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getTargetId());
                }
                if (value.getTargetType() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getTargetType());
                }
                if (value.getPinnedBy() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getPinnedBy());
                }
                String _tmp = PinDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getPinnedAt());
                if (_tmp == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp);
                }
                String _tmp_1 = PinDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLastPinsUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_1);
                }
                String _tmp_2 = PinDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_2);
                }
                String _tmp_3 = PinDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_3);
                }
                String _tmp_4 = PinDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_4);
                }
                if (value.getPinId() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getPinId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "delete from pin";
                return "delete from pin";
            }
        };
        this.__preparedStmtOfUpdatePin = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE pin set pinId = pinId";
                return "UPDATE pin set pinId = pinId";
            }
        };
    }

    @Override
    public void insertImpl(PinEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPinEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends PinEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPinEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(PinEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfPinEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends PinEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfPinEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(PinEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfPinEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(PinEntity object) {
        this.__db.beginTransaction();
        try {
            PinDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends PinEntity> objects) {
        this.__db.beginTransaction();
        try {
            PinDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(PinEntity object) {
        this.__db.beginTransaction();
        try {
            PinDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    public void updatePin() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdatePin.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdatePin.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PinEntity getByIdNowImpl(String id) {
        String _sql = "select * from pin where pinId = ? limit 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from pin where pinId = ? limit 1", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            PinEntity _result;
            int _cursorIndexOfPinId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinId");
            int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
            int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
            int _cursorIndexOfPlacement = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"placement");
            int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
            int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
            int _cursorIndexOfPinnedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinnedBy");
            int _cursorIndexOfPinnedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinnedAt");
            int _cursorIndexOfLastPinsUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastPinsUpdatedAt");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                String _tmpPinId = _cursor.isNull(_cursorIndexOfPinId) ? null : _cursor.getString(_cursorIndexOfPinId);
                String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                String _tmpPlacement = _cursor.isNull(_cursorIndexOfPlacement) ? null : _cursor.getString(_cursorIndexOfPlacement);
                String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                String _tmpPinnedBy = _cursor.isNull(_cursorIndexOfPinnedBy) ? null : _cursor.getString(_cursorIndexOfPinnedBy);
                String _tmp = _cursor.isNull(_cursorIndexOfPinnedAt) ? null : _cursor.getString(_cursorIndexOfPinnedAt);
                DateTime _tmpPinnedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfLastPinsUpdatedAt) ? null : _cursor.getString(_cursorIndexOfLastPinsUpdatedAt);
                DateTime _tmpLastPinsUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result = new PinEntity(_tmpPinId, _tmpReferenceId, _tmpReferenceType, _tmpPlacement, _tmpTargetId, _tmpTargetType, _tmpPinnedBy, _tmpPinnedAt, _tmpLastPinsUpdatedAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            PinEntity pinEntity = _result;
            return pinEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

