package  com.amity.socialcloud.sdk.model.core.follow

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityMyFollowInfo internal constructor(
        private val followerCount: Int = 0,
        private val followingCount: Int = 0,
        private val pendingRequestCount: Int = 0
) : Parcelable {

    fun getFollowerCount(): Int {
        return followerCount
    }

    fun getFollowingCount(): Int {
        return followingCount
    }

    fun getPendingRequestCount(): Int {
        return pendingRequestCount
    }
}
