package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.ekoapp.ekosdk.internal.SubChannelEntity
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable
import org.joda.time.DateTime

@Dao
abstract class SubChannelDao : EkoObjectDao<SubChannelEntity>() {

    @Query("select * from sub_channel where subChannelId = :subChanelId")
    abstract fun getSubChannel(subChanelId: String): Flowable<SubChannelEntity>

    @Query("select * from sub_channel where subChannelId = :id limit 1")
    abstract fun getByIdNowImpl(id: String): SubChannelEntity?

    override fun getByIdNow(id: String): SubChannelEntity? {
        return getByIdNowImpl(id)
    }

    @Query("select * from sub_channel where subChannelId IN (:subChanelId)")
    abstract fun observeSubChanel(subChanelId: String): Flowable<List<SubChannelEntity>>

    @Query("delete from sub_channel")
    abstract override fun deleteAll()

    @Query("delete from sub_channel where subChannelId = :subChanelId")
    abstract fun deleteById(subChanelId: String): Completable

    @Query("update sub_channel set isDeleted = 1 where subChannelId = :subChanelId ")
    abstract fun softDeleteById(subChanelId: String): Completable

    @Query(
        "SELECT *" +
                " from sub_channel" +
                " where case when :isDeleted is not null then sub_channel.isDeleted = :isDeleted" +
                " else sub_channel.subChannelId is not null end" + // always true
                " and sub_channel.updatedAt > :now" +
                " and sub_channel.subChannelId not in " +
                "(" +
                "SELECT amity_paging_id.id" +
                " from amity_paging_id" +
                " where amity_paging_id.hash = (:hash)" +
                " and amity_paging_id.nonce = (:nonce) " +
                ")" +
                " order by sub_channel.updatedAt desc" +
                " limit 1"
    )
    abstract fun getLatestSubChannelImpl(
        isDeleted: Boolean?,
        hash: Int,
        nonce: Int,
        now: DateTime
    ): Flowable<SubChannelEntity>

    fun getLatestSubChannel(
        isDeleted: Boolean?,
        hash: Int,
        nonce: Int,
        now: DateTime
    ): Flowable<SubChannelEntity> {
        return getLatestSubChannelImpl(isDeleted, hash, nonce, now)
    }

    @Query("UPDATE sub_channel set subChannelMarkerHash = :hash where subChannelId = :subChannelId")
    abstract fun updateMarkerHash(subChannelId: String, hash: Int)

    @Query("UPDATE sub_channel set userSubChannelMarkerHash = :hash where subChannelId = :subChannelId")
    abstract fun updateUserMarkerHash(subChannelId: String, hash: Int)

    @Query("UPDATE sub_channel set lastActivity = :lastActivity where subChannelId = :subChannelId")
    abstract fun updateLastActivity(subChannelId: String, lastActivity: DateTime)

    @Query("UPDATE sub_channel set latestMessageId = :messageId where subChannelId = :subChannelId")
    abstract fun updateLatestMessage(subChannelId: String, messageId: String)
    
    @Query("UPDATE sub_channel set messagePreviewId = :messagePreviewId where subChannelId = :subChannelId")
    abstract fun updateMessagePreview(subChannelId: String, messagePreviewId: String)
    
    @Query("UPDATE sub_channel set subChannelId = :subChannelId where subChannelId = :subChannelId")
    abstract fun notifyChanges(subChannelId: String)
    
    @Query("UPDATE sub_channel set subChannelMarkerHash = :hash where subChannelId in (:subChannelIds)")
    abstract fun notifySubChannelsChanges(subChannelIds: List<String>, hash: Int)
}