package com.amity.socialcloud.sdk.core.data.user.paging

import co.amity.rxbridge.toRx2
import com.amity.socialcloud.sdk.core.data.user.UserQueryPersister
import com.amity.socialcloud.sdk.core.data.user.UserRemoteDataStore
import com.amity.socialcloud.sdk.entity.core.user.UserEntity
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import com.amity.socialcloud.sdk.api.core.user.search.AmityUserSortOption
import com.ekoapp.ekosdk.internal.api.dto.EkoUserListDto
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.mediator.DynamicQueryStreamMediator
import com.ekoapp.ekosdk.internal.token.DynamicQueryStreamQueryToken
import io.reactivex.Completable
import io.reactivex.Flowable
import io.reactivex.Single

internal class UserMediator(
    private val keyword: String?,
    private val sortBy: AmityUserSortOption
) : DynamicQueryStreamMediator<UserEntity, EkoUserListDto, AmityUser>(

    nonce = AmityNonce.USER_LIST,
    dynamicQueryStreamKeyCreator = UserKeyCreator(
        keyword = keyword ?: "",
        sortBy = sortBy
    )
) {

    override fun forceRefresh() = true

    override fun provideReactorPublisher(): Flowable<AmityUser> {
        return Flowable.empty()
    }

    override fun getFirstPageRequest(pageSize: Int): Single<EkoUserListDto> {
        return getRequest(limit = pageSize)
    }

    override fun getFetchByTokenRequest(token: String): Single<EkoUserListDto> {
        return getRequest(token = token)
    }

    override fun persistResponse(dto: EkoUserListDto): Completable {
        return UserQueryPersister().persist(dto).toRx2()
    }

    override fun convertResponseToQueryToken(dto: EkoUserListDto): DynamicQueryStreamQueryToken {
        return DynamicQueryStreamQueryToken(
            dynamicQueryStreamKeyCreator = dynamicQueryStreamKeyCreator,
            next = dto.token?.next,
            previous = dto.token?.previous,
            primaryKeys = dto.users?.map { it.userId } ?: emptyList()
        )
    }

    private fun getRequest(
        limit: Int? = null,
        token: String? = null
    ): Single<EkoUserListDto> {
        return UserRemoteDataStore().getUsers(
            keyword = keyword,
            sortBy = sortBy.apiKey,
            limit = limit,
            token = token
        ).toRx2()
    }

}