/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.EmptyResultSetException;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.AnalyticsEventDao;
import com.ekoapp.ekosdk.internal.entity.AnalyticsEventEntity;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Single;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class AnalyticsEventDao_Impl
extends AnalyticsEventDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<AnalyticsEventEntity> __insertionAdapterOfAnalyticsEventEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<AnalyticsEventEntity> __deletionAdapterOfAnalyticsEventEntity;
    private final EntityDeletionOrUpdateAdapter<AnalyticsEventEntity> __updateAdapterOfAnalyticsEventEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteOldestEvent;

    public AnalyticsEventDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfAnalyticsEventEntity = new EntityInsertionAdapter<AnalyticsEventEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `analytics_event` (`eventId`,`userId`,`contentId`,`contentType`,`activityType`,`metadata`,`deduplicationKey`,`syncPriority`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, AnalyticsEventEntity value) {
                if (value.getEventId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getEventId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getUserId());
                }
                if (value.getContentId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getContentId());
                }
                if (value.getContentType() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getContentType());
                }
                if (value.getActivityType() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getActivityType());
                }
                String _tmp = AnalyticsEventDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp);
                }
                if (value.getDeduplicationKey() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getDeduplicationKey());
                }
                if (value.getSyncPriority() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getSyncPriority());
                }
                String _tmp_1 = AnalyticsEventDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_1);
                }
                String _tmp_2 = AnalyticsEventDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_2);
                }
                String _tmp_3 = AnalyticsEventDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_3);
                }
            }
        };
        this.__deletionAdapterOfAnalyticsEventEntity = new EntityDeletionOrUpdateAdapter<AnalyticsEventEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `analytics_event` WHERE `eventId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AnalyticsEventEntity value) {
                if (value.getEventId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getEventId());
                }
            }
        };
        this.__updateAdapterOfAnalyticsEventEntity = new EntityDeletionOrUpdateAdapter<AnalyticsEventEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `analytics_event` SET `eventId` = ?,`userId` = ?,`contentId` = ?,`contentType` = ?,`activityType` = ?,`metadata` = ?,`deduplicationKey` = ?,`syncPriority` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `eventId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AnalyticsEventEntity value) {
                if (value.getEventId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getEventId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getUserId());
                }
                if (value.getContentId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getContentId());
                }
                if (value.getContentType() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getContentType());
                }
                if (value.getActivityType() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getActivityType());
                }
                String _tmp = AnalyticsEventDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp);
                }
                if (value.getDeduplicationKey() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getDeduplicationKey());
                }
                if (value.getSyncPriority() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getSyncPriority());
                }
                String _tmp_1 = AnalyticsEventDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_1);
                }
                String _tmp_2 = AnalyticsEventDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_2);
                }
                String _tmp_3 = AnalyticsEventDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_3);
                }
                if (value.getEventId() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getEventId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from analytics_event";
                return "DELETE from analytics_event";
            }
        };
        this.__preparedStmtOfDeleteOldestEvent = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "delete from analytics_event where eventId in (select eventId from analytics_event order by createdAt asc limit 1)";
                return "delete from analytics_event where eventId in (select eventId from analytics_event order by createdAt asc limit 1)";
            }
        };
    }

    @Override
    public void insertImpl(AnalyticsEventEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfAnalyticsEventEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends AnalyticsEventEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfAnalyticsEventEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(AnalyticsEventEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfAnalyticsEventEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends AnalyticsEventEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfAnalyticsEventEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(AnalyticsEventEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfAnalyticsEventEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(AnalyticsEventEntity object) {
        this.__db.beginTransaction();
        try {
            AnalyticsEventDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends AnalyticsEventEntity> objects) {
        this.__db.beginTransaction();
        try {
            AnalyticsEventDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(AnalyticsEventEntity object) {
        this.__db.beginTransaction();
        try {
            AnalyticsEventDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    public void deleteOldestEvent() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteOldestEvent.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteOldestEvent.release(_stmt);
        }
    }

    @Override
    public Single<List<AnalyticsEventEntity>> getAnalyticEvents(String userId, String syncPriority, int limit) {
        String _sql = "select * from analytics_event where userId =? and syncPriority = ? order by createdAt desc limit ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from analytics_event where userId =? and syncPriority = ? order by createdAt desc limit ?", (int)3);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        _argIndex = 2;
        if (syncPriority == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, syncPriority);
        }
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)limit);
        return RxRoom.createSingle((Callable)new Callable<List<AnalyticsEventEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AnalyticsEventEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)AnalyticsEventDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfEventId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"eventId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfContentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentId");
                    int _cursorIndexOfContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentType");
                    int _cursorIndexOfActivityType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activityType");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfDeduplicationKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deduplicationKey");
                    int _cursorIndexOfSyncPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncPriority");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    ArrayList<AnalyticsEventEntity> _result = new ArrayList<AnalyticsEventEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpEventId = _cursor.isNull(_cursorIndexOfEventId) ? null : _cursor.getString(_cursorIndexOfEventId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        String _tmpContentId = _cursor.isNull(_cursorIndexOfContentId) ? null : _cursor.getString(_cursorIndexOfContentId);
                        String _tmpContentType = _cursor.isNull(_cursorIndexOfContentType) ? null : _cursor.getString(_cursorIndexOfContentType);
                        String _tmpActivityType = _cursor.isNull(_cursorIndexOfActivityType) ? null : _cursor.getString(_cursorIndexOfActivityType);
                        String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = AnalyticsEventDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                        String _tmpDeduplicationKey = _cursor.isNull(_cursorIndexOfDeduplicationKey) ? null : _cursor.getString(_cursorIndexOfDeduplicationKey);
                        String _tmpSyncPriority = _cursor.isNull(_cursorIndexOfSyncPriority) ? null : _cursor.getString(_cursorIndexOfSyncPriority);
                        AnalyticsEventEntity _item = new AnalyticsEventEntity(_tmpEventId, _tmpUserId, _tmpContentId, _tmpContentType, _tmpActivityType, _tmpMetadata, _tmpDeduplicationKey, _tmpSyncPriority);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = AnalyticsEventDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _item.setCreatedAt(_tmpCreatedAt);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = AnalyticsEventDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _item.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = AnalyticsEventDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _item.setExpiresAt(_tmpExpiresAt);
                        _result.add(_item);
                    }
                    if (_result == null) {
                        throw new EmptyResultSetException("Query returned empty result set: " + _statement.getSql());
                    }
                    ArrayList<AnalyticsEventEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Single<Integer> getAnalyticEventsCount() {
        String _sql = "SELECT count(*) from analytics_event";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT count(*) from analytics_event", (int)0);
        return RxRoom.createSingle((Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)AnalyticsEventDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    Integer _result;
                    if (_cursor.moveToFirst()) {
                        Integer _tmp = _cursor.isNull(0) ? null : Integer.valueOf(_cursor.getInt(0));
                        _result = _tmp;
                    } else {
                        _result = null;
                    }
                    if (_result == null) {
                        throw new EmptyResultSetException("Query returned empty result set: " + _statement.getSql());
                    }
                    Integer n = _result;
                    return n;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalyticsEventEntity getByIdNowImpl(String id) {
        String _sql = "select * from analytics_event where userId = ? limit 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from analytics_event where userId = ? limit 1", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            AnalyticsEventEntity _result;
            int _cursorIndexOfEventId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"eventId");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfContentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentId");
            int _cursorIndexOfContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentType");
            int _cursorIndexOfActivityType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activityType");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfDeduplicationKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deduplicationKey");
            int _cursorIndexOfSyncPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncPriority");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                String _tmpEventId = _cursor.isNull(_cursorIndexOfEventId) ? null : _cursor.getString(_cursorIndexOfEventId);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                String _tmpContentId = _cursor.isNull(_cursorIndexOfContentId) ? null : _cursor.getString(_cursorIndexOfContentId);
                String _tmpContentType = _cursor.isNull(_cursorIndexOfContentType) ? null : _cursor.getString(_cursorIndexOfContentType);
                String _tmpActivityType = _cursor.isNull(_cursorIndexOfActivityType) ? null : _cursor.getString(_cursorIndexOfActivityType);
                String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                String _tmpDeduplicationKey = _cursor.isNull(_cursorIndexOfDeduplicationKey) ? null : _cursor.getString(_cursorIndexOfDeduplicationKey);
                String _tmpSyncPriority = _cursor.isNull(_cursorIndexOfSyncPriority) ? null : _cursor.getString(_cursorIndexOfSyncPriority);
                _result = new AnalyticsEventEntity(_tmpEventId, _tmpUserId, _tmpContentId, _tmpContentType, _tmpActivityType, _tmpMetadata, _tmpDeduplicationKey, _tmpSyncPriority);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            AnalyticsEventEntity analyticsEventEntity = _result;
            return analyticsEventEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

