package com.ekoapp.ekosdk.internal.usecase.permission

import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.core.data.permission.PermissionRepository
import com.amity.socialcloud.sdk.model.core.permission.AmityPermission
import io.reactivex.rxjava3.core.Flowable

internal class ChannelPermissionValidatorUseCase {

    fun execute(permission: AmityPermission, channelId: String): Flowable<Boolean> {
        val membershipPermission =
            PermissionRepository().getChannelPermission(channelId, AmityCoreClient.getUserId())
        val globalPermission =
            PermissionRepository().getGlobalPermission(AmityCoreClient.getUserId())
        return Flowable.combineLatest(membershipPermission, globalPermission) { t1, t2 ->
            t1.contains(permission) || t2.contains(permission)
        }
    }

}