package com.amity.socialcloud.sdk.chat.data.channel.membership.paging

import android.text.BoringLayout
import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.api.chat.member.query.AmityChannelMembershipSortOption
import com.amity.socialcloud.sdk.model.chat.member.AmityMembershipType
import com.amity.socialcloud.sdk.model.core.role.AmityRoles
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao

@Dao
internal interface ChannelMembershipPagingDao : DynamicQueryStreamPagingDao<ChannelMembershipEntity> {

    @RawQuery(observedEntities = [ChannelMembershipEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, ChannelMembershipEntity>

    fun getChannelMembershipPagingSource(
        channelId: String,
        memberships: List<AmityMembershipType>,
        isMuted: Boolean?,
        isDeleted: Boolean?,
        roles: AmityRoles,
        sortOption: AmityChannelMembershipSortOption?
    ): PagingSource<Int, ChannelMembershipEntity> {
        val order = if(sortOption == null || sortOption == AmityChannelMembershipSortOption.FIRST_CREATED) AmityPagingDao.Order.ASC else AmityPagingDao.Order.DESC
        val query = generateQueryStreamSQL(
                tableName = "channel_membership",
                primaryKeyColumnName = "userId",
                additionalPrimaryKeys = mapOf("channelId" to channelId),
                nonce = AmityNonce.CHANNEL_MEMBERSHIP,
                sortColumn = "createdAt",
                order = order,
                dynamicQueryStreamKeyCreator = ChannelMembershipKeyCreator(
                    channelId = channelId,
                    memberships = memberships,
                    isMuted = isMuted,
                    roles = roles,
                    isDeleted = isDeleted,
                    sortOption = sortOption
                )
            )
        return queryPagingData(query)
    }

}