package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.ekoapp.ekosdk.internal.ReadReceiptEntity
import io.reactivex.rxjava3.core.Flowable

@Dao
abstract class ReadReceiptDao : EkoObjectDao<ReadReceiptEntity>() {
	@Query("SELECT * from read_receipt where subChannelId = :subChannelId LIMIT 1")
	abstract fun getById(subChannelId: String): Flowable<ReadReceiptEntity>
	
	@Query("SELECT * from read_receipt where subChannelId = :subChannelId LIMIT 1")
	abstract override fun getByIdNow(subChannelId: String): ReadReceiptEntity?
	
	@Query("DELETE from read_receipt")
	abstract override fun deleteAll()
	
	@Query("DELETE from read_receipt where subChannelId = :subChannelId")
	abstract fun deleteBySubChannelId(subChannelId: String)
	
	@Query("UPDATE read_receipt set latestSegment = :segment where subChannelId = :subChannelId and latestSegment < :segment")
	abstract fun updateLatestSegment(subChannelId: String, segment: Int)
	
	@Query("UPDATE read_receipt set latestSyncSegment = :segment where subChannelId = :subChannelId and latestSyncSegment < :segment")
	abstract fun updateLatestSyncSegment(subChannelId: String, segment: Int)
	
	@Query("SELECT * from read_receipt where latestSyncSegment < latestSegment")
	abstract fun getUnsyncReadReceipts(): List<ReadReceiptEntity>
}