package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.core.MarkerEvent
import com.amity.socialcloud.sdk.core.session.eventbus.MarkerEventBus
import com.ekoapp.ekosdk.internal.api.dto.ChannelEventDto
import io.reactivex.rxjava3.core.Single
import io.reactivex.rxjava3.schedulers.Schedulers
import java.util.concurrent.TimeUnit

internal class ChannelDeleted : ChannelEventListener() {

    override fun getEventName(): String {
        return "channel.deleted"
    }
    
    override fun processEvent(dto: ChannelEventDto) {
        super.processEvent(dto)
        MarkerEventBus.publish(MarkerEvent.ChannelDeleted(getEventName(), dto))
        
        // Do this to ensure that marker service already receive channel.deleted event
        // Remove when marker service inconsistent mode is obsoleted
        Single.just(true)
            .delay(2, TimeUnit.SECONDS)
            .doOnSuccess {
                // Delay to ensure that channel is already deleted before start marker sync
                // as a temporary solution until backend has a solution to handle this case.
                MarkerEventBus.publish(MarkerEvent.MarkerUpdated(getEventName()))
            }
            .subscribeOn(Schedulers.io())
            .subscribe()
    }

}