/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.EkoCategoryIds;
import com.ekoapp.ekosdk.internal.data.converter.EkoCategoriesTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoTagsTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityDao;
import com.ekoapp.ekosdk.internal.entity.CommunityEntity;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoCommunityDao_Impl
extends EkoCommunityDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<CommunityEntity> __insertionAdapterOfCommunityEntity;
    private final EkoTagsTypeConverter __ekoTagsTypeConverter = new EkoTagsTypeConverter();
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EkoCategoriesTypeConverter __ekoCategoriesTypeConverter = new EkoCategoriesTypeConverter();
    private final EntityDeletionOrUpdateAdapter<CommunityEntity> __deletionAdapterOfCommunityEntity;
    private final EntityDeletionOrUpdateAdapter<CommunityEntity> __updateAdapterOfCommunityEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByCommunityIdImpl;
    private final SharedSQLiteStatement __preparedStmtOfUpdateIsJoinedImpl;

    public EkoCommunityDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCommunityEntity = new EntityInsertionAdapter<CommunityEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `community` (`communityId`,`mid`,`path`,`channelId`,`userId`,`displayName`,`description`,`avatarFileId`,`isOfficial`,`isPublic`,`onlyAdminCanPost`,`tags`,`metadata`,`postsCount`,`membersCount`,`isJoined`,`isDeleted`,`needApprovalOnPostCreation`,`allowCommentInStory`,`editedAt`,`categoryIds`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, CommunityEntity value) {
                Integer _tmp_8;
                Integer _tmp_7;
                Integer _tmp_6;
                Integer _tmp_5;
                Integer _tmp_2;
                Integer _tmp_1;
                Integer _tmp;
                if (value.getCommunityId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommunityId());
                }
                if (value.getMid() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMid());
                }
                if (value.getPath() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getPath());
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getChannelId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getUserId());
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getDisplayName());
                }
                if (value.getDescription() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getDescription());
                }
                if (value.getAvatarFileId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getAvatarFileId());
                }
                Integer n = value.isOfficial() == null ? null : (_tmp = Integer.valueOf(value.isOfficial() != false ? 1 : 0));
                if (_tmp == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindLong(9, (long)_tmp.intValue());
                }
                Integer n2 = value.isPublic() == null ? null : (_tmp_1 = Integer.valueOf(value.isPublic() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindLong(10, (long)_tmp_1.intValue());
                }
                Integer n3 = value.getOnlyAdminCanPost() == null ? null : (_tmp_2 = Integer.valueOf(value.getOnlyAdminCanPost() != false ? 1 : 0));
                if (_tmp_2 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindLong(11, (long)_tmp_2.intValue());
                }
                String _tmp_3 = EkoCommunityDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(value.getTags());
                if (_tmp_3 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_3);
                }
                String _tmp_4 = EkoCommunityDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp_4 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_4);
                }
                if (value.getPostsCount() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindLong(14, (long)value.getPostsCount().intValue());
                }
                if (value.getMembersCount() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindLong(15, (long)value.getMembersCount().intValue());
                }
                Integer n4 = value.isJoined() == null ? null : (_tmp_5 = Integer.valueOf(value.isJoined() != false ? 1 : 0));
                if (_tmp_5 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindLong(16, (long)_tmp_5.intValue());
                }
                Integer n5 = value.isDeleted() == null ? null : (_tmp_6 = Integer.valueOf(value.isDeleted() != false ? 1 : 0));
                if (_tmp_6 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindLong(17, (long)_tmp_6.intValue());
                }
                Integer n6 = value.getNeedApprovalOnPostCreation() == null ? null : (_tmp_7 = Integer.valueOf(value.getNeedApprovalOnPostCreation() != false ? 1 : 0));
                if (_tmp_7 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindLong(18, (long)_tmp_7.intValue());
                }
                Integer n7 = value.getAllowCommentInStory() == null ? null : (_tmp_8 = Integer.valueOf(value.getAllowCommentInStory() != false ? 1 : 0));
                if (_tmp_8 == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindLong(19, (long)_tmp_8.intValue());
                }
                String _tmp_9 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEditedAt());
                if (_tmp_9 == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, _tmp_9);
                }
                String _tmp_10 = EkoCommunityDao_Impl.this.__ekoCategoriesTypeConverter.ekoCategoriesToString(value.getCategoryIds());
                if (_tmp_10 == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, _tmp_10);
                }
                String _tmp_11 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_11 == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, _tmp_11);
                }
                String _tmp_12 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_12 == null) {
                    stmt.bindNull(23);
                } else {
                    stmt.bindString(23, _tmp_12);
                }
                String _tmp_13 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_13 == null) {
                    stmt.bindNull(24);
                } else {
                    stmt.bindString(24, _tmp_13);
                }
            }
        };
        this.__deletionAdapterOfCommunityEntity = new EntityDeletionOrUpdateAdapter<CommunityEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `community` WHERE `communityId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, CommunityEntity value) {
                if (value.getCommunityId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommunityId());
                }
            }
        };
        this.__updateAdapterOfCommunityEntity = new EntityDeletionOrUpdateAdapter<CommunityEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `community` SET `communityId` = ?,`mid` = ?,`path` = ?,`channelId` = ?,`userId` = ?,`displayName` = ?,`description` = ?,`avatarFileId` = ?,`isOfficial` = ?,`isPublic` = ?,`onlyAdminCanPost` = ?,`tags` = ?,`metadata` = ?,`postsCount` = ?,`membersCount` = ?,`isJoined` = ?,`isDeleted` = ?,`needApprovalOnPostCreation` = ?,`allowCommentInStory` = ?,`editedAt` = ?,`categoryIds` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `communityId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, CommunityEntity value) {
                Integer _tmp_8;
                Integer _tmp_7;
                Integer _tmp_6;
                Integer _tmp_5;
                Integer _tmp_2;
                Integer _tmp_1;
                Integer _tmp;
                if (value.getCommunityId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommunityId());
                }
                if (value.getMid() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMid());
                }
                if (value.getPath() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getPath());
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getChannelId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getUserId());
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getDisplayName());
                }
                if (value.getDescription() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getDescription());
                }
                if (value.getAvatarFileId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getAvatarFileId());
                }
                Integer n = value.isOfficial() == null ? null : (_tmp = Integer.valueOf(value.isOfficial() != false ? 1 : 0));
                if (_tmp == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindLong(9, (long)_tmp.intValue());
                }
                Integer n2 = value.isPublic() == null ? null : (_tmp_1 = Integer.valueOf(value.isPublic() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindLong(10, (long)_tmp_1.intValue());
                }
                Integer n3 = value.getOnlyAdminCanPost() == null ? null : (_tmp_2 = Integer.valueOf(value.getOnlyAdminCanPost() != false ? 1 : 0));
                if (_tmp_2 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindLong(11, (long)_tmp_2.intValue());
                }
                String _tmp_3 = EkoCommunityDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(value.getTags());
                if (_tmp_3 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_3);
                }
                String _tmp_4 = EkoCommunityDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp_4 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_4);
                }
                if (value.getPostsCount() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindLong(14, (long)value.getPostsCount().intValue());
                }
                if (value.getMembersCount() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindLong(15, (long)value.getMembersCount().intValue());
                }
                Integer n4 = value.isJoined() == null ? null : (_tmp_5 = Integer.valueOf(value.isJoined() != false ? 1 : 0));
                if (_tmp_5 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindLong(16, (long)_tmp_5.intValue());
                }
                Integer n5 = value.isDeleted() == null ? null : (_tmp_6 = Integer.valueOf(value.isDeleted() != false ? 1 : 0));
                if (_tmp_6 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindLong(17, (long)_tmp_6.intValue());
                }
                Integer n6 = value.getNeedApprovalOnPostCreation() == null ? null : (_tmp_7 = Integer.valueOf(value.getNeedApprovalOnPostCreation() != false ? 1 : 0));
                if (_tmp_7 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindLong(18, (long)_tmp_7.intValue());
                }
                Integer n7 = value.getAllowCommentInStory() == null ? null : (_tmp_8 = Integer.valueOf(value.getAllowCommentInStory() != false ? 1 : 0));
                if (_tmp_8 == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindLong(19, (long)_tmp_8.intValue());
                }
                String _tmp_9 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEditedAt());
                if (_tmp_9 == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, _tmp_9);
                }
                String _tmp_10 = EkoCommunityDao_Impl.this.__ekoCategoriesTypeConverter.ekoCategoriesToString(value.getCategoryIds());
                if (_tmp_10 == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, _tmp_10);
                }
                String _tmp_11 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_11 == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, _tmp_11);
                }
                String _tmp_12 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_12 == null) {
                    stmt.bindNull(23);
                } else {
                    stmt.bindString(23, _tmp_12);
                }
                String _tmp_13 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_13 == null) {
                    stmt.bindNull(24);
                } else {
                    stmt.bindString(24, _tmp_13);
                }
                if (value.getCommunityId() == null) {
                    stmt.bindNull(25);
                } else {
                    stmt.bindString(25, value.getCommunityId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from community";
                return "DELETE from community";
            }
        };
        this.__preparedStmtOfDeleteByCommunityIdImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE community set isDeleted = 1 where communityId = ?";
                return "UPDATE community set isDeleted = 1 where communityId = ?";
            }
        };
        this.__preparedStmtOfUpdateIsJoinedImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE community set communityId = ? where communityId = ?";
                return "UPDATE community set communityId = ? where communityId = ?";
            }
        };
    }

    @Override
    public void insertImpl(CommunityEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCommunityEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends CommunityEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCommunityEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(CommunityEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfCommunityEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends CommunityEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfCommunityEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(CommunityEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfCommunityEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(CommunityEntity community) {
        this.__db.beginTransaction();
        try {
            EkoCommunityDao_Impl.super.insert(community);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends CommunityEntity> communities) {
        this.__db.beginTransaction();
        try {
            EkoCommunityDao_Impl.super.insert(communities);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(CommunityEntity community) {
        this.__db.beginTransaction();
        try {
            EkoCommunityDao_Impl.super.update(community);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(List<? extends CommunityEntity> communities) {
        this.__db.beginTransaction();
        try {
            EkoCommunityDao_Impl.super.update(communities);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateIsJoined(String communityId) {
        this.__db.beginTransaction();
        try {
            EkoCommunityDao_Impl.super.updateIsJoined(communityId);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    Completable deleteByCommunityIdImpl(final String communityId) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = EkoCommunityDao_Impl.this.__preparedStmtOfDeleteByCommunityIdImpl.acquire();
                int _argIndex = 1;
                if (communityId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, communityId);
                }
                EkoCommunityDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    EkoCommunityDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    EkoCommunityDao_Impl.this.__db.endTransaction();
                    EkoCommunityDao_Impl.this.__preparedStmtOfDeleteByCommunityIdImpl.release(_stmt);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateIsJoinedImpl(String communityId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateIsJoinedImpl.acquire();
        int _argIndex = 1;
        if (communityId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, communityId);
        }
        _argIndex = 2;
        if (communityId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, communityId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateIsJoinedImpl.release(_stmt);
        }
    }

    @Override
    Flowable<CommunityEntity> getByCommunityIdImpl(String communityId) {
        String _sql = "SELECT * from community where community.communityId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from community where community.communityId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (communityId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, communityId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"community"}, (Callable)new Callable<CommunityEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CommunityEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoCommunityDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    CommunityEntity _result;
                    int _cursorIndexOfCommunityId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"communityId");
                    int _cursorIndexOfMid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mid");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
                    int _cursorIndexOfIsOfficial = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isOfficial");
                    int _cursorIndexOfIsPublic = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPublic");
                    int _cursorIndexOfOnlyAdminCanPost = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"onlyAdminCanPost");
                    int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfPostsCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postsCount");
                    int _cursorIndexOfMembersCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"membersCount");
                    int _cursorIndexOfIsJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isJoined");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfNeedApprovalOnPostCreation = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"needApprovalOnPostCreation");
                    int _cursorIndexOfAllowCommentInStory = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"allowCommentInStory");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfCategoryIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"categoryIds");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new CommunityEntity();
                        String _tmpCommunityId = _cursor.isNull(_cursorIndexOfCommunityId) ? null : _cursor.getString(_cursorIndexOfCommunityId);
                        _result.setCommunityId(_tmpCommunityId);
                        String _tmpMid = _cursor.isNull(_cursorIndexOfMid) ? null : _cursor.getString(_cursorIndexOfMid);
                        _result.setMid(_tmpMid);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _result.setPath(_tmpPath);
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                        _result.setDisplayName(_tmpDisplayName);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        _result.setDescription(_tmpDescription);
                        String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                        _result.setAvatarFileId(_tmpAvatarFileId);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfIsOfficial) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsOfficial));
                        Boolean _tmpIsOfficial = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                        _result.setOfficial(_tmpIsOfficial);
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfIsPublic) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsPublic));
                        Boolean _tmpIsPublic = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                        _result.setPublic(_tmpIsPublic);
                        Integer _tmp_2 = _cursor.isNull(_cursorIndexOfOnlyAdminCanPost) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfOnlyAdminCanPost));
                        Boolean _tmpOnlyAdminCanPost = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                        _result.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                        AmityTags _tmpTags = EkoCommunityDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_3);
                        _result.setTags(_tmpTags);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoCommunityDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                        _result.setMetadata(_tmpMetadata);
                        Integer _tmpPostsCount = _cursor.isNull(_cursorIndexOfPostsCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfPostsCount));
                        _result.setPostsCount(_tmpPostsCount);
                        Integer _tmpMembersCount = _cursor.isNull(_cursorIndexOfMembersCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMembersCount));
                        _result.setMembersCount(_tmpMembersCount);
                        Integer _tmp_5 = _cursor.isNull(_cursorIndexOfIsJoined) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsJoined));
                        Boolean _tmpIsJoined = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                        _result.setJoined(_tmpIsJoined);
                        Integer _tmp_6 = _cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsDeleted));
                        Boolean _tmpIsDeleted = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                        _result.setDeleted(_tmpIsDeleted);
                        Integer _tmp_7 = _cursor.isNull(_cursorIndexOfNeedApprovalOnPostCreation) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfNeedApprovalOnPostCreation));
                        Boolean _tmpNeedApprovalOnPostCreation = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                        _result.setNeedApprovalOnPostCreation(_tmpNeedApprovalOnPostCreation);
                        Integer _tmp_8 = _cursor.isNull(_cursorIndexOfAllowCommentInStory) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfAllowCommentInStory));
                        Boolean _tmpAllowCommentInStory = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                        _result.setAllowCommentInStory(_tmpAllowCommentInStory);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        _result.setEditedAt(_tmpEditedAt);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfCategoryIds) ? null : _cursor.getString(_cursorIndexOfCategoryIds);
                        EkoCategoryIds _tmpCategoryIds = EkoCommunityDao_Impl.this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_10);
                        _result.setCategoryIds(_tmpCategoryIds);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_13 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    CommunityEntity communityEntity = _result;
                    return communityEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    Flowable<List<CommunityEntity>> observeByCommunityIdsImpl(List<String> communityIds) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from community where community.communityId in (");
        int _inputSize = communityIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : communityIds) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"community"}, (Callable)new Callable<List<CommunityEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<CommunityEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoCommunityDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfCommunityId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"communityId");
                    int _cursorIndexOfMid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mid");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
                    int _cursorIndexOfIsOfficial = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isOfficial");
                    int _cursorIndexOfIsPublic = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPublic");
                    int _cursorIndexOfOnlyAdminCanPost = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"onlyAdminCanPost");
                    int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfPostsCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postsCount");
                    int _cursorIndexOfMembersCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"membersCount");
                    int _cursorIndexOfIsJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isJoined");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfNeedApprovalOnPostCreation = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"needApprovalOnPostCreation");
                    int _cursorIndexOfAllowCommentInStory = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"allowCommentInStory");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfCategoryIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"categoryIds");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    ArrayList<CommunityEntity> _result = new ArrayList<CommunityEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        CommunityEntity _item_1 = new CommunityEntity();
                        String _tmpCommunityId = _cursor.isNull(_cursorIndexOfCommunityId) ? null : _cursor.getString(_cursorIndexOfCommunityId);
                        _item_1.setCommunityId(_tmpCommunityId);
                        String _tmpMid = _cursor.isNull(_cursorIndexOfMid) ? null : _cursor.getString(_cursorIndexOfMid);
                        _item_1.setMid(_tmpMid);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _item_1.setPath(_tmpPath);
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _item_1.setChannelId(_tmpChannelId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _item_1.setUserId(_tmpUserId);
                        String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                        _item_1.setDisplayName(_tmpDisplayName);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        _item_1.setDescription(_tmpDescription);
                        String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                        _item_1.setAvatarFileId(_tmpAvatarFileId);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfIsOfficial) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsOfficial));
                        Boolean _tmpIsOfficial = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                        _item_1.setOfficial(_tmpIsOfficial);
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfIsPublic) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsPublic));
                        Boolean _tmpIsPublic = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                        _item_1.setPublic(_tmpIsPublic);
                        Integer _tmp_2 = _cursor.isNull(_cursorIndexOfOnlyAdminCanPost) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfOnlyAdminCanPost));
                        Boolean _tmpOnlyAdminCanPost = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                        _item_1.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                        AmityTags _tmpTags = EkoCommunityDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_3);
                        _item_1.setTags(_tmpTags);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoCommunityDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                        _item_1.setMetadata(_tmpMetadata);
                        Integer _tmpPostsCount = _cursor.isNull(_cursorIndexOfPostsCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfPostsCount));
                        _item_1.setPostsCount(_tmpPostsCount);
                        Integer _tmpMembersCount = _cursor.isNull(_cursorIndexOfMembersCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMembersCount));
                        _item_1.setMembersCount(_tmpMembersCount);
                        Integer _tmp_5 = _cursor.isNull(_cursorIndexOfIsJoined) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsJoined));
                        Boolean _tmpIsJoined = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                        _item_1.setJoined(_tmpIsJoined);
                        Integer _tmp_6 = _cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsDeleted));
                        Boolean _tmpIsDeleted = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                        _item_1.setDeleted(_tmpIsDeleted);
                        Integer _tmp_7 = _cursor.isNull(_cursorIndexOfNeedApprovalOnPostCreation) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfNeedApprovalOnPostCreation));
                        Boolean _tmpNeedApprovalOnPostCreation = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                        _item_1.setNeedApprovalOnPostCreation(_tmpNeedApprovalOnPostCreation);
                        Integer _tmp_8 = _cursor.isNull(_cursorIndexOfAllowCommentInStory) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfAllowCommentInStory));
                        Boolean _tmpAllowCommentInStory = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                        _item_1.setAllowCommentInStory(_tmpAllowCommentInStory);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        _item_1.setEditedAt(_tmpEditedAt);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfCategoryIds) ? null : _cursor.getString(_cursorIndexOfCategoryIds);
                        EkoCategoryIds _tmpCategoryIds = EkoCommunityDao_Impl.this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_10);
                        _item_1.setCategoryIds(_tmpCategoryIds);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                        _item_1.setCreatedAt(_tmpCreatedAt);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                        _item_1.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_13 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                        _item_1.setExpiresAt(_tmpExpiresAt);
                        _result.add(_item_1);
                    }
                    ArrayList<CommunityEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CommunityEntity getByIdNowImpl(String communityId) {
        String _sql = "SELECT * from community where communityId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from community where communityId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (communityId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, communityId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            CommunityEntity _result;
            int _cursorIndexOfCommunityId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"communityId");
            int _cursorIndexOfMid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mid");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
            int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
            int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
            int _cursorIndexOfIsOfficial = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isOfficial");
            int _cursorIndexOfIsPublic = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPublic");
            int _cursorIndexOfOnlyAdminCanPost = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"onlyAdminCanPost");
            int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfPostsCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postsCount");
            int _cursorIndexOfMembersCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"membersCount");
            int _cursorIndexOfIsJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isJoined");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfNeedApprovalOnPostCreation = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"needApprovalOnPostCreation");
            int _cursorIndexOfAllowCommentInStory = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"allowCommentInStory");
            int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
            int _cursorIndexOfCategoryIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"categoryIds");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new CommunityEntity();
                String _tmpCommunityId = _cursor.isNull(_cursorIndexOfCommunityId) ? null : _cursor.getString(_cursorIndexOfCommunityId);
                _result.setCommunityId(_tmpCommunityId);
                String _tmpMid = _cursor.isNull(_cursorIndexOfMid) ? null : _cursor.getString(_cursorIndexOfMid);
                _result.setMid(_tmpMid);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                _result.setPath(_tmpPath);
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _result.setChannelId(_tmpChannelId);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _result.setUserId(_tmpUserId);
                String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                _result.setDisplayName(_tmpDisplayName);
                String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                _result.setDescription(_tmpDescription);
                String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                _result.setAvatarFileId(_tmpAvatarFileId);
                Integer _tmp = _cursor.isNull(_cursorIndexOfIsOfficial) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsOfficial));
                Boolean _tmpIsOfficial = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                _result.setOfficial(_tmpIsOfficial);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfIsPublic) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsPublic));
                Boolean _tmpIsPublic = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                _result.setPublic(_tmpIsPublic);
                Integer _tmp_2 = _cursor.isNull(_cursorIndexOfOnlyAdminCanPost) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfOnlyAdminCanPost));
                Boolean _tmpOnlyAdminCanPost = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                _result.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_3);
                _result.setTags(_tmpTags);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                _result.setMetadata(_tmpMetadata);
                Integer _tmpPostsCount = _cursor.isNull(_cursorIndexOfPostsCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfPostsCount));
                _result.setPostsCount(_tmpPostsCount);
                Integer _tmpMembersCount = _cursor.isNull(_cursorIndexOfMembersCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMembersCount));
                _result.setMembersCount(_tmpMembersCount);
                Integer _tmp_5 = _cursor.isNull(_cursorIndexOfIsJoined) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsJoined));
                Boolean _tmpIsJoined = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                _result.setJoined(_tmpIsJoined);
                Integer _tmp_6 = _cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsDeleted));
                Boolean _tmpIsDeleted = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                _result.setDeleted(_tmpIsDeleted);
                Integer _tmp_7 = _cursor.isNull(_cursorIndexOfNeedApprovalOnPostCreation) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfNeedApprovalOnPostCreation));
                Boolean _tmpNeedApprovalOnPostCreation = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                _result.setNeedApprovalOnPostCreation(_tmpNeedApprovalOnPostCreation);
                Integer _tmp_8 = _cursor.isNull(_cursorIndexOfAllowCommentInStory) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfAllowCommentInStory));
                Boolean _tmpAllowCommentInStory = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                _result.setAllowCommentInStory(_tmpAllowCommentInStory);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                _result.setEditedAt(_tmpEditedAt);
                String _tmp_10 = _cursor.isNull(_cursorIndexOfCategoryIds) ? null : _cursor.getString(_cursorIndexOfCategoryIds);
                EkoCategoryIds _tmpCategoryIds = this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_10);
                _result.setCategoryIds(_tmpCategoryIds);
                String _tmp_11 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_12 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_13 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            CommunityEntity communityEntity = _result;
            return communityEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<CommunityEntity> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from community where community.communityId IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfCommunityId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"communityId");
            int _cursorIndexOfMid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mid");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
            int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
            int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
            int _cursorIndexOfIsOfficial = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isOfficial");
            int _cursorIndexOfIsPublic = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPublic");
            int _cursorIndexOfOnlyAdminCanPost = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"onlyAdminCanPost");
            int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfPostsCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postsCount");
            int _cursorIndexOfMembersCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"membersCount");
            int _cursorIndexOfIsJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isJoined");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfNeedApprovalOnPostCreation = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"needApprovalOnPostCreation");
            int _cursorIndexOfAllowCommentInStory = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"allowCommentInStory");
            int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
            int _cursorIndexOfCategoryIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"categoryIds");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            ArrayList<CommunityEntity> _result = new ArrayList<CommunityEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                CommunityEntity _item_1 = new CommunityEntity();
                String _tmpCommunityId = _cursor.isNull(_cursorIndexOfCommunityId) ? null : _cursor.getString(_cursorIndexOfCommunityId);
                _item_1.setCommunityId(_tmpCommunityId);
                String _tmpMid = _cursor.isNull(_cursorIndexOfMid) ? null : _cursor.getString(_cursorIndexOfMid);
                _item_1.setMid(_tmpMid);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                _item_1.setPath(_tmpPath);
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _item_1.setChannelId(_tmpChannelId);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _item_1.setUserId(_tmpUserId);
                String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                _item_1.setDisplayName(_tmpDisplayName);
                String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                _item_1.setDescription(_tmpDescription);
                String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                _item_1.setAvatarFileId(_tmpAvatarFileId);
                Integer _tmp = _cursor.isNull(_cursorIndexOfIsOfficial) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsOfficial));
                Boolean _tmpIsOfficial = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                _item_1.setOfficial(_tmpIsOfficial);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfIsPublic) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsPublic));
                Boolean _tmpIsPublic = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                _item_1.setPublic(_tmpIsPublic);
                Integer _tmp_2 = _cursor.isNull(_cursorIndexOfOnlyAdminCanPost) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfOnlyAdminCanPost));
                Boolean _tmpOnlyAdminCanPost = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                _item_1.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_3);
                _item_1.setTags(_tmpTags);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                _item_1.setMetadata(_tmpMetadata);
                Integer _tmpPostsCount = _cursor.isNull(_cursorIndexOfPostsCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfPostsCount));
                _item_1.setPostsCount(_tmpPostsCount);
                Integer _tmpMembersCount = _cursor.isNull(_cursorIndexOfMembersCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMembersCount));
                _item_1.setMembersCount(_tmpMembersCount);
                Integer _tmp_5 = _cursor.isNull(_cursorIndexOfIsJoined) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsJoined));
                Boolean _tmpIsJoined = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                _item_1.setJoined(_tmpIsJoined);
                Integer _tmp_6 = _cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsDeleted));
                Boolean _tmpIsDeleted = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                _item_1.setDeleted(_tmpIsDeleted);
                Integer _tmp_7 = _cursor.isNull(_cursorIndexOfNeedApprovalOnPostCreation) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfNeedApprovalOnPostCreation));
                Boolean _tmpNeedApprovalOnPostCreation = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                _item_1.setNeedApprovalOnPostCreation(_tmpNeedApprovalOnPostCreation);
                Integer _tmp_8 = _cursor.isNull(_cursorIndexOfAllowCommentInStory) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfAllowCommentInStory));
                Boolean _tmpAllowCommentInStory = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                _item_1.setAllowCommentInStory(_tmpAllowCommentInStory);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                _item_1.setEditedAt(_tmpEditedAt);
                String _tmp_10 = _cursor.isNull(_cursorIndexOfCategoryIds) ? null : _cursor.getString(_cursorIndexOfCategoryIds);
                EkoCategoryIds _tmpCategoryIds = this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_10);
                _item_1.setCategoryIds(_tmpCategoryIds);
                String _tmp_11 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_12 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_13 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                _item_1.setExpiresAt(_tmpExpiresAt);
                _result.add(_item_1);
            }
            ArrayList<CommunityEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    Flowable<CommunityEntity> getLatestCommunityImpl(Boolean isFilterByCategoryId, String categoryId, Boolean isFilterByMembership, Boolean isJoined, Boolean isDeleted, int hash, int nonce, DateTime now) {
        Integer _tmp_4;
        Integer _tmp_3;
        Integer _tmp_2;
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT * from community where community.isJoined = (case when ? then ? else isJoined end) and case when ? then community.communityId in (SELECT communityId from category where categoryId in (?)) else community.communityId is not null end and community.isDeleted = (case when ? is null then isDeleted else ? end) and community.updatedAt > ? and community.communityId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by community.updatedAt  desc limit 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from community where community.isJoined = (case when ? then ? else isJoined end) and case when ? then community.communityId in (SELECT communityId from category where categoryId in (?)) else community.communityId is not null end and community.isDeleted = (case when ? is null then isDeleted else ? end) and community.updatedAt > ? and community.communityId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by community.updatedAt  desc limit 1", (int)9);
        int _argIndex = 1;
        Integer n = isFilterByMembership == null ? null : (_tmp = Integer.valueOf(isFilterByMembership != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        Integer n2 = isJoined == null ? null : (_tmp_1 = Integer.valueOf(isJoined != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 3;
        Integer n3 = isFilterByCategoryId == null ? null : (_tmp_2 = Integer.valueOf(isFilterByCategoryId != false ? 1 : 0));
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_2.intValue());
        }
        _argIndex = 4;
        if (categoryId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, categoryId);
        }
        _argIndex = 5;
        Integer n4 = isDeleted == null ? null : (_tmp_3 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_3 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_3.intValue());
        }
        _argIndex = 6;
        Integer n5 = isDeleted == null ? null : (_tmp_4 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_4 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_4.intValue());
        }
        _argIndex = 7;
        String _tmp_5 = this.__dateTimeTypeConverter.dateTimeToString(now);
        if (_tmp_5 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp_5);
        }
        _argIndex = 8;
        _statement.bindLong(_argIndex, (long)hash);
        _argIndex = 9;
        _statement.bindLong(_argIndex, (long)nonce);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"community", "category", "amity_paging_id"}, (Callable)new Callable<CommunityEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CommunityEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoCommunityDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    CommunityEntity _result;
                    int _cursorIndexOfCommunityId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"communityId");
                    int _cursorIndexOfMid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mid");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
                    int _cursorIndexOfIsOfficial = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isOfficial");
                    int _cursorIndexOfIsPublic = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPublic");
                    int _cursorIndexOfOnlyAdminCanPost = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"onlyAdminCanPost");
                    int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfPostsCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postsCount");
                    int _cursorIndexOfMembersCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"membersCount");
                    int _cursorIndexOfIsJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isJoined");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfNeedApprovalOnPostCreation = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"needApprovalOnPostCreation");
                    int _cursorIndexOfAllowCommentInStory = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"allowCommentInStory");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfCategoryIds = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"categoryIds");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new CommunityEntity();
                        String _tmpCommunityId = _cursor.isNull(_cursorIndexOfCommunityId) ? null : _cursor.getString(_cursorIndexOfCommunityId);
                        _result.setCommunityId(_tmpCommunityId);
                        String _tmpMid = _cursor.isNull(_cursorIndexOfMid) ? null : _cursor.getString(_cursorIndexOfMid);
                        _result.setMid(_tmpMid);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _result.setPath(_tmpPath);
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                        _result.setDisplayName(_tmpDisplayName);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        _result.setDescription(_tmpDescription);
                        String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                        _result.setAvatarFileId(_tmpAvatarFileId);
                        Integer _tmp_6 = _cursor.isNull(_cursorIndexOfIsOfficial) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsOfficial));
                        Boolean _tmpIsOfficial = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                        _result.setOfficial(_tmpIsOfficial);
                        Integer _tmp_7 = _cursor.isNull(_cursorIndexOfIsPublic) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsPublic));
                        Boolean _tmpIsPublic = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                        _result.setPublic(_tmpIsPublic);
                        Integer _tmp_8 = _cursor.isNull(_cursorIndexOfOnlyAdminCanPost) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfOnlyAdminCanPost));
                        Boolean _tmpOnlyAdminCanPost = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                        _result.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                        AmityTags _tmpTags = EkoCommunityDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_9);
                        _result.setTags(_tmpTags);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoCommunityDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_10);
                        _result.setMetadata(_tmpMetadata);
                        Integer _tmpPostsCount = _cursor.isNull(_cursorIndexOfPostsCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfPostsCount));
                        _result.setPostsCount(_tmpPostsCount);
                        Integer _tmpMembersCount = _cursor.isNull(_cursorIndexOfMembersCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMembersCount));
                        _result.setMembersCount(_tmpMembersCount);
                        Integer _tmp_11 = _cursor.isNull(_cursorIndexOfIsJoined) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsJoined));
                        Boolean _tmpIsJoined = _tmp_11 == null ? null : Boolean.valueOf(_tmp_11 != 0);
                        _result.setJoined(_tmpIsJoined);
                        Integer _tmp_12 = _cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsDeleted));
                        Boolean _tmpIsDeleted = _tmp_12 == null ? null : Boolean.valueOf(_tmp_12 != 0);
                        _result.setDeleted(_tmpIsDeleted);
                        Integer _tmp_13 = _cursor.isNull(_cursorIndexOfNeedApprovalOnPostCreation) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfNeedApprovalOnPostCreation));
                        Boolean _tmpNeedApprovalOnPostCreation = _tmp_13 == null ? null : Boolean.valueOf(_tmp_13 != 0);
                        _result.setNeedApprovalOnPostCreation(_tmpNeedApprovalOnPostCreation);
                        Integer _tmp_14 = _cursor.isNull(_cursorIndexOfAllowCommentInStory) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfAllowCommentInStory));
                        Boolean _tmpAllowCommentInStory = _tmp_14 == null ? null : Boolean.valueOf(_tmp_14 != 0);
                        _result.setAllowCommentInStory(_tmpAllowCommentInStory);
                        String _tmp_15 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                        _result.setEditedAt(_tmpEditedAt);
                        String _tmp_16 = _cursor.isNull(_cursorIndexOfCategoryIds) ? null : _cursor.getString(_cursorIndexOfCategoryIds);
                        EkoCategoryIds _tmpCategoryIds = EkoCommunityDao_Impl.this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_16);
                        _result.setCategoryIds(_tmpCategoryIds);
                        String _tmp_17 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_17);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_18 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_18);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_19 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_19);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    CommunityEntity communityEntity = _result;
                    return communityEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

