/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.ChatSettingsEntity;
import com.ekoapp.ekosdk.internal.data.dao.ChatSettingsDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class ChatSettingsDao_Impl
extends ChatSettingsDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ChatSettingsEntity> __insertionAdapterOfChatSettingsEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<ChatSettingsEntity> __deletionAdapterOfChatSettingsEntity;
    private final EntityDeletionOrUpdateAdapter<ChatSettingsEntity> __updateAdapterOfChatSettingsEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public ChatSettingsDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfChatSettingsEntity = new EntityInsertionAdapter<ChatSettingsEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `chat_settings` (`settingId`,`enabled`,`isAllowMentionedChannelEnabled`,`messagePreviewSetting`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ChatSettingsEntity value) {
                if (value.getSettingId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSettingId());
                }
                int _tmp = value.getEnabled() ? 1 : 0;
                stmt.bindLong(2, (long)_tmp);
                int _tmp_1 = value.isAllowMentionedChannelEnabled() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp_1);
                if (value.getMessagePreviewSetting() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getMessagePreviewSetting());
                }
                String _tmp_2 = ChatSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                String _tmp_3 = ChatSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_3);
                }
                String _tmp_4 = ChatSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_4);
                }
            }
        };
        this.__deletionAdapterOfChatSettingsEntity = new EntityDeletionOrUpdateAdapter<ChatSettingsEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `chat_settings` WHERE `settingId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ChatSettingsEntity value) {
                if (value.getSettingId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSettingId());
                }
            }
        };
        this.__updateAdapterOfChatSettingsEntity = new EntityDeletionOrUpdateAdapter<ChatSettingsEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `chat_settings` SET `settingId` = ?,`enabled` = ?,`isAllowMentionedChannelEnabled` = ?,`messagePreviewSetting` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `settingId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ChatSettingsEntity value) {
                if (value.getSettingId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSettingId());
                }
                int _tmp = value.getEnabled() ? 1 : 0;
                stmt.bindLong(2, (long)_tmp);
                int _tmp_1 = value.isAllowMentionedChannelEnabled() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp_1);
                if (value.getMessagePreviewSetting() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getMessagePreviewSetting());
                }
                String _tmp_2 = ChatSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                String _tmp_3 = ChatSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_3);
                }
                String _tmp_4 = ChatSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_4);
                }
                if (value.getSettingId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getSettingId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from chat_settings";
                return "DELETE from chat_settings";
            }
        };
    }

    @Override
    public void insertImpl(ChatSettingsEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfChatSettingsEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends ChatSettingsEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfChatSettingsEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(ChatSettingsEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfChatSettingsEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends ChatSettingsEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfChatSettingsEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(ChatSettingsEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfChatSettingsEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(ChatSettingsEntity object) {
        this.__db.beginTransaction();
        try {
            ChatSettingsDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends ChatSettingsEntity> objects) {
        this.__db.beginTransaction();
        try {
            ChatSettingsDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(ChatSettingsEntity object) {
        this.__db.beginTransaction();
        try {
            ChatSettingsDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    public Flowable<ChatSettingsEntity> getChatSettings(String settingId) {
        String _sql = "select * from chat_settings where settingId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from chat_settings where settingId = ?", (int)1);
        int _argIndex = 1;
        if (settingId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, settingId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"chat_settings"}, (Callable)new Callable<ChatSettingsEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ChatSettingsEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ChatSettingsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ChatSettingsEntity _result;
                    int _cursorIndexOfSettingId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"settingId");
                    int _cursorIndexOfEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"enabled");
                    int _cursorIndexOfIsAllowMentionedChannelEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isAllowMentionedChannelEnabled");
                    int _cursorIndexOfMessagePreviewSetting = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messagePreviewSetting");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new ChatSettingsEntity();
                        String _tmpSettingId = _cursor.isNull(_cursorIndexOfSettingId) ? null : _cursor.getString(_cursorIndexOfSettingId);
                        _result.setSettingId(_tmpSettingId);
                        int _tmp = _cursor.getInt(_cursorIndexOfEnabled);
                        boolean _tmpEnabled = _tmp != 0;
                        _result.setEnabled(_tmpEnabled);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsAllowMentionedChannelEnabled);
                        boolean _tmpIsAllowMentionedChannelEnabled = _tmp_1 != 0;
                        _result.setAllowMentionedChannelEnabled(_tmpIsAllowMentionedChannelEnabled);
                        String _tmpMessagePreviewSetting = _cursor.isNull(_cursorIndexOfMessagePreviewSetting) ? null : _cursor.getString(_cursorIndexOfMessagePreviewSetting);
                        _result.setMessagePreviewSetting(_tmpMessagePreviewSetting);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = ChatSettingsDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = ChatSettingsDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = ChatSettingsDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    ChatSettingsEntity chatSettingsEntity = _result;
                    return chatSettingsEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

