package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import androidx.room.ForeignKey
import com.ekoapp.ekosdk.internal.entity.CommunityMembershipEntity
import com.ekoapp.ekosdk.internal.util.EkoPreconditions
import com.google.common.base.MoreObjects
import com.google.common.base.Objects

@Entity(tableName = "community_role",
		primaryKeys = ["communityId", "userId", "roleName"],
		foreignKeys = [
			ForeignKey(
				entity = CommunityMembershipEntity::class,
				parentColumns = ["communityId", "userId"],
				childColumns = ["communityId", "userId"],
				onDelete = ForeignKey.CASCADE
			)])
data class CommunityMembershipRoleEntity constructor(
	val communityId: String,
	val userId: String,
	val roleName: String
) : EkoRoleObject() {
	
	override fun equals(obj: Any?): Boolean {
		if (obj == null) return false
		if (obj === this) return true
		if (obj.javaClass != javaClass) return false
		val other = obj as CommunityMembershipRoleEntity
		return (Objects.equal(communityId, other.communityId)
				&& Objects.equal(userId, other.userId)
				&& Objects.equal(roleName, other.roleName))
	}
	
	override fun hashCode(): Int {
		return Objects.hashCode(
				communityId,
				userId,
				roleName
		)
	}
	
	override fun toString(): String {
		return MoreObjects.toStringHelper(this)
				.add("communityId", communityId)
				.add("userId", userId)
				.add("roleName", roleName)
				.toString()
	}
	
	companion object {
		@JvmStatic
        fun create(communityId: String, userId: String, roleName: String): CommunityMembershipRoleEntity {
			val communityId = EkoPreconditions.checkValidId(communityId, "communityId")
			val userId = EkoPreconditions.checkValidId(userId, "userId")
			val roleName = EkoPreconditions.checkValidId(roleName, "roleName")
			return CommunityMembershipRoleEntity(communityId, userId, roleName)
		}
	}
}