package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.ekoapp.ekosdk.internal.data.model.PinEntity

@Dao
abstract class PinDao : EkoObjectDao<PinEntity>() {
    @Query("delete from pin")
    abstract override fun deleteAll()

    @Query("select * from pin where pinId = :id limit 1")
    abstract fun getByIdNowImpl(id: String): PinEntity?

    override fun getByIdNow(id: String): PinEntity? {
        return getByIdNowImpl(id)
    }
}