package com.amity.socialcloud.sdk.social.domain.post.create

import com.amity.socialcloud.sdk.model.core.error.AmityError
import com.amity.socialcloud.sdk.model.core.error.AmityException
import com.amity.socialcloud.sdk.model.core.file.AmityFile
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.data.post.PostRepository
import com.amity.socialcloud.sdk.social.domain.post.PostGetUseCase
import com.ekoapp.ekosdk.internal.usecase.post.PostCreateUseCase
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single


internal class FilePostCreateUseCase : PostCreateUseCase {

    fun execute(
        targetType: String,
        targetId: String,
        files: List<AmityFile>,
        text: String,
        metadata: JsonObject?,
        mentionUserIds: List<String>?
    ): Single<AmityPost> {
        return PostRepository().createPostV4(
            targetType = targetType,
            targetId = targetId,
            data = composeData(text),
            dataType = null,
            attachments = mapAttachments(files, AmityPost.DataType.FILE.getApiKey()),
            metadata = metadata,
            mentionees = mapMentionees(mentionUserIds)
        ).flatMap {
            val post = PostGetUseCase().execute(it)
            if (post != null) {
                Single.just(post)
            } else {
                Single.error(
                    AmityException.create(
                        "Post not found",
                        null,
                        AmityError.ITEM_NOT_FOUND
                    )
                )
            }
        }
    }

    private fun composeData(text: String): JsonObject {
        return JsonObject().apply { addProperty("text", text) }
    }

}