package com.ekoapp.ekosdk.internal.data.model;

import static com.ekoapp.ekosdk.internal.util.EkoPreconditions.checkValidId;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.PrimaryKey;

@Entity(tableName = "socket_url")
public class EkoSocketUrl {

    private static final String SINGLETON_SOCKET_URL_ID = "SINGLETON_SOCKET_URL_ID";

    @PrimaryKey
    @NonNull
    private String id = currentSocketUrlId();
    private String socketUrl;
    private long updateAt = System.currentTimeMillis();


    public static String currentSocketUrlId() {
        return SINGLETON_SOCKET_URL_ID;
    }

    @NonNull
    public String getId() {
        return currentSocketUrlId();
    }

    public void setId(String id) {
        // NO OP
        this.id = currentSocketUrlId();
    }

    @NonNull
    public String getSocketUrl() {
        return socketUrl;
    }

    public void setSocketUrl(@NonNull String httpUrl) {
        this.socketUrl = checkValidId(httpUrl, "socketUrl");
    }

    public long getUpdateAt() {
        return updateAt;
    }

    public void setUpdateAt(long updateAt) {
        this.updateAt = updateAt;
    }

    public static EkoSocketUrl create(@NonNull String url) {
        EkoSocketUrl ekoSocketUrl = new EkoSocketUrl();
        ekoSocketUrl.setSocketUrl(url);
        return ekoSocketUrl;
    }
}
