package com.ekoapp.ekosdk.internal.api

import com.google.common.base.MoreObjects
import io.socket.client.Socket
import java.util.*

class SocketConnectionEvent internal constructor(val userId: String, socket: Socket, event: String, args: Array<Any>) {
	val isConnected: Boolean
	@JvmField
    val event: String
	val args: Array<Any>
	
	init {
		isConnected = socket.connected()
		this.event = event
		this.args = args
	}
	
	override fun toString(): String {
		return MoreObjects.toStringHelper(this)
				.add("userId", userId)
				.add("isConnected", isConnected)
				.add("event", event)
				.add("args", Arrays.deepToString(args))
				.toString()
	}
}