package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.core.MarkerEvent
import com.amity.socialcloud.sdk.core.session.eventbus.MarkerEventBus
import com.ekoapp.ekosdk.internal.api.dto.MarkedMessageDto
import kotlin.reflect.KClass

internal class MarkerMarkedMessage: MqttEventListener<MarkedMessageDto>()  {

    override val type: KClass<MarkedMessageDto>
        get() = MarkedMessageDto::class

    override fun processEvent(dto: MarkedMessageDto) {
        MarkerEventBus.publish(MarkerEvent.MarkedMessage(dto))
    }

    override fun shouldProcessEvent(dto: MarkedMessageDto): Boolean {
        return true
    }
    
    override fun getEventName(): String {
        return "marker.marked-message"
    }
    
}