package com.amity.socialcloud.sdk.core.domain.user

import com.amity.socialcloud.sdk.core.data.user.UserRepository
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.schedulers.Schedulers

internal class UserGetUseCase {

    fun execute(userId: String) : AmityUser? {
        val user = UserRepository().getUser(userId)
        Completable.fromCallable {
            user?.let {
                UserComposerUseCase().execute(it)
            }
        }.subscribeOn(Schedulers.io())
            .blockingAwait()
        return  user
    }

}