package com.amity.socialcloud.sdk.core.data.session

import com.ekoapp.ekosdk.internal.data.EkoDatabase
import com.ekoapp.ekosdk.internal.data.model.EkoAccount
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single
import io.reactivex.rxjava3.schedulers.Schedulers

internal class SessionLocalDataStore {

    fun getApiKey(): Single<EkoApiKey> {
        return EkoDatabase.get().apiKeyDao().currentApiKeySingle
    }

    fun activateAccount(userId: String): EkoAccount {
        return EkoDatabase.get().accountDao().activateAccount(userId)
    }

    fun updateAccount(account: EkoAccount): Completable {
        return Completable.fromAction {
            EkoDatabase.get().accountDao().update(account)
        }.subscribeOn(Schedulers.io())
    }

    fun logoutAccount(userId: String) {
        EkoDatabase.get().accountDao().logoutAccount(userId)
    }

    fun getActiveUserId(): String {
        var activeUserId = ""
        Completable.fromCallable {
            val account = EkoDatabase.get().accountDao().currentAccountNow
            account?.userId?.let {
                activeUserId = it
            }
        }.subscribeOn(Schedulers.io())
            .blockingAwait()
        return activeUserId
    }

    fun getCurrentAccount(): EkoAccount? {
        return EkoDatabase.get().accountDao().currentAccountNow
    }
}