package com.amity.socialcloud.sdk.chat.domain.channel

import com.amity.socialcloud.sdk.api.chat.channel.create.AmityChannelCreator
import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import com.amity.socialcloud.sdk.chat.domain.channel.ChannelComposerUseCase
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.model.chat.channel.ChannelCreateOption
import io.reactivex.rxjava3.core.Single

internal class CreateChannelUseCase {

    fun execute(creationType: AmityChannelCreator.CreationType,
                option: ChannelCreateOption
    ): Single<AmityChannel> {
        return ChannelRepository().createChannel(creationType, option)
            .map {
                ChannelComposerUseCase().execute(it)
            }
    }

}