package com.amity.socialcloud.sdk.chat.data.marker.channel

import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerLocalDataStore
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerRepository
import com.amity.socialcloud.sdk.core.CoreClient
import com.amity.socialcloud.sdk.model.core.unread.UserUnread
import com.ekoapp.ekosdk.internal.ChannelMarkerEntity
import com.ekoapp.ekosdk.internal.ChannelUnreadInfoEntity
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable

internal class ChannelMarkerRepository {
    
    fun fetchChannelMarker(channelIds: List<String>): Completable {
        return if (!CoreClient.isUnreadCountEnable() || channelIds.isEmpty()){
            Completable.complete()
        } else {
            if (CoreClient.isConsistentMode()) {
                SubChannelMarkerRepository().fetchSubChannelUnreadInfo(channelIds)
                    .onErrorComplete()
            } else {
                ChannelMarkerRemoteDataStore().queryChannelMarkers(channelIds)
                    .flatMapCompletable {
                        ChannelMarkerQueryPersister().persist(it)
                    }
            }
        }
    }
    
    fun getChannelMarker(channelId: String): ChannelMarkerEntity? {
        return ChannelMarkerLocalDataStore().getChannelMarker(channelId)
    }
    
    fun saveChannelMarkers(channelMarkers: List<ChannelMarkerEntity>): Completable {
        return Completable.fromAction {
            channelMarkers.filter { it.isDeleted }.map { channelMarker ->
                SubChannelMarkerLocalDataStore().deleteSubChannelByChannelId(channelMarker.channelId)
            }
        }
                .onErrorComplete()
                .andThen(ChannelMarkerLocalDataStore().saveChannelMarkers(channelMarkers))
    }
    
    fun markChannelAsRead(channelId: String): Completable {
        return ChannelMarkerRemoteDataStore().markChannelAsRead(channelId)
            .flatMapCompletable {
                ChannelMarkAsReadPersister().persist(it)
            }
    }
    
    fun getChannelUnreadInfo(channelId: String): ChannelUnreadInfoEntity? {
        return ChannelMarkerLocalDataStore().getChannelUnreadInfo(channelId)
    }
    
    fun saveChannelUnreadInfo(channelUnreadInfos: List<ChannelUnreadInfoEntity>) {
        ChannelMarkerLocalDataStore().saveChannelUnreadInfo(channelUnreadInfos)
    }

    fun getTotalChannelsUnreadInfo(): Flowable<UserUnread> {
        return ChannelMarkerLocalDataStore().getTotalChannelsUnreadInfo()
    }
}