package com.amity.socialcloud.sdk.chat.data.channel.singlepage

import com.amity.socialcloud.sdk.chat.data.channel.ChannelRemoteDataStore
import com.amity.socialcloud.sdk.chat.data.channel.paging.ChannelQueryDtoPersister
import com.ekoapp.ekosdk.internal.EkoChannelEntity
import com.ekoapp.ekosdk.internal.api.dto.ChannelQueryDto
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.mediator.SinglePageMediator
import com.ekoapp.ekosdk.internal.token.DynamicQueryStreamQueryToken
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single

internal class ChannelListMediator(
    private val channelIds: List<String>
) : SinglePageMediator<EkoChannelEntity, ChannelQueryDto>(
    nonce = AmityNonce.CHANNEL_LIST,
    dynamicQueryStreamKeyCreator = ChannelListKeyCreator(channelIds = channelIds)
){

    override fun persistResponse(dto: ChannelQueryDto): Completable {
        return ChannelQueryDtoPersister().persistDto(dto)
    }
    
    override fun getRequest(): Single<ChannelQueryDto> {
        return ChannelRemoteDataStore().getChannels(
            channelIds = channelIds,
        )
    }
    
    override fun convertResponseToQueryToken(dto: ChannelQueryDto): DynamicQueryStreamQueryToken {
        return DynamicQueryStreamQueryToken(
                dynamicQueryStreamKeyCreator = dynamicQueryStreamKeyCreator,
                next = dto.token?.next,
                previous = dto.token?.previous,
                primaryKeys = dto.channelDtoList?.map { it.channelId } ?: emptyList()
        )
    }
}