package com.ekoapp.ekosdk.internal.api.mapper;

import com.amity.socialcloud.sdk.log.AmityLog;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.internal.api.dto.EkoObjectDto;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import com.github.davidmoten.guavamini.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.util.List;
import java.util.Map;

public abstract class EkoObjectPersister {

    private static final String TAG = EkoObjectPersister.class.getName();

    static <DTO extends EkoObjectDto, EKO extends EkoObject> void persistChanges(
            List<DTO> dtoList,
            EkoObjectMapper<DTO,EKO> mapper,
            EkoObjectDao<EKO> dao) {
        List<EKO> fromNetwork = mapper.map(dtoList);
        List<String> idsFromNetwork = Lists.transform(fromNetwork, EkoObject::getId);
        List<EKO> onDisk = dao.getByIdsNow(idsFromNetwork);
        Map<String,EKO> onDiskMap = Maps.uniqueIndex(onDisk, EkoObject::getId);

        List<EKO> freshObjects = Lists.newArrayList();
        List<EKO> changedObjects = Lists.newArrayList();

        for (EKO objectFromNetwork : fromNetwork) {
            final String id = objectFromNetwork.getId();
            EKO objectOnDisk = onDiskMap.get(id);
            if (!onDiskMap.containsKey(id)) {
                AmityLog.INSTANCE.tag(TAG).i("new object: id: %s objectFromNetwork: %s", id, objectFromNetwork);
                freshObjects.add(objectFromNetwork);
            } else if(!Objects.equal(objectFromNetwork, objectOnDisk)) {
                EKO changedObject = mapper.update(objectOnDisk, objectFromNetwork);
                AmityLog.INSTANCE.tag(TAG).i("object changed: id: %s changedObject: %s", id, changedObject);
                changedObjects.add(changedObject);
            }
        }

        if (!freshObjects.isEmpty()) {
            dao.insert(freshObjects);
        }

        if (!changedObjects.isEmpty()) {
            dao.update(changedObjects);
        }
    }

}
