package com.ekoapp.ekosdk.internal.api.dto;

import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionMap;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.ekoapp.ekosdk.EkoFlag;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;

import org.joda.time.DateTime;

import java.util.Collections;
import java.util.List;

public class EkoMessageDto extends EkoObjectDto {

    @SerializedName("messageId")
    private String messageId;

    @SerializedName("referenceId")
    private String referenceId;

    @SerializedName("messageFeedId")
    private String subChannelId;

    @SerializedName("channelPublicId")
    private String channelId;

    @SerializedName("channelType")
    private String channelType;

    @SerializedName("creatorPublicId")
    private String userId;

    @SerializedName("parentId")
    private String parentId;

    @SerializedName("dataType")
    private String type;

    @SerializedName("segment")
    private int segment;

    @SerializedName("childCount")
    private int childrenNumber;

    @SerializedName("data")
    private JsonObject data;

    @SerializedName("metadata")
    private JsonObject metadata;

    @SerializedName("isDeleted")
    private boolean isDeleted;

    @SerializedName("flagCount")
    private int flagCount;

    @SerializedName("tags")
    private AmityTags tags;

    @SerializedName("hashFlag")
    private EkoFlag flag;

    @SerializedName("reactions")
    private AmityReactionMap reactions;

    @SerializedName("reactionCount")
    private int reactionCount;

    @SerializedName("myReactions")
    private List<String> myReactions;

    @SerializedName("mentionedUsers")
    List<MentioneeDto> mentionees = Collections.emptyList();

    @SerializedName("editedAt")
    private DateTime editedAt;

    @SerializedName("path")
    private String path;

    @SerializedName("fileId")
    private String fileId;

    @SerializedName("latestReaction")
    private EkoReactorDto latestReaction;

    public String getMessageId() {
        return messageId;
    }

    public String getSubChannelId() {
        return subChannelId;
    }

    public String getReferenceId() {
        if(referenceId != null) {
            return referenceId;
        }
        else {
            return messageId;
        }
    }

    public String getPath() {
        if(path != null) return path; else return "";
    }

    public String getChannelId() {
        // BE issue: there could be null channelId from message event
        if(channelId != null) {
            return channelId;
        } else {
            return "";
        }
    }

    public String getChannelType() {
        return channelType;
    }

    public String getUserId() {
        return userId;
    }

    public String getParentId() {
        return parentId;
    }

    public String getType() {
        return type;
    }

    public String getFileId() {
        return fileId;
    }

    public int getSegment() {
        return segment;
    }

    public int getChildrenNumber() {
        return childrenNumber;
    }

    public DateTime getEditedAt() {
        return editedAt;
    }

    public JsonObject getData() {
        return data;
    }

    public boolean isDeleted() {
        return isDeleted;
    }

    public int getFlagCount() {
        return flagCount;
    }

    public AmityTags getTags() {
        return tags;
    }

    public EkoFlag getFlag() {
        return flag;
    }

    public AmityReactionMap getReactions() {
        return reactions;
    }

    public int getReactionCount() {
        return reactionCount;
    }

    public List<String> getMyReactions() {
        return myReactions;
    }

    public EkoReactorDto getLatestReaction() {
        return latestReaction;
    }

    public void setLatestReaction(EkoReactorDto latestReaction) {
        this.latestReaction = latestReaction;
    }

    public JsonObject getMetadata() {
        return metadata;
    }

    public List<MentioneeDto> getMentionees() {
        return mentionees;
    }

    public void setMentionees(List<MentioneeDto> mentionees) {
        this.mentionees = mentionees;
    }
}
