package com.amity.socialcloud.sdk.core.data.pin

import androidx.paging.ExperimentalPagingApi
import androidx.paging.PagingConfig
import androidx.paging.PagingData
import co.amity.rxbridge.toRx3
import com.amity.socialcloud.sdk.core.data.pin.paging.PinnedPostMediator
import com.amity.socialcloud.sdk.model.core.pin.AmityPinSortByOptions
import com.amity.socialcloud.sdk.model.core.pin.AmityPinnedPost
import com.ekoapp.ekosdk.EkoObjectRepository
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator
import io.reactivex.rxjava3.core.Flowable

internal class PinRepository() : EkoObjectRepository() {
	
	private fun getDefaultPageSize(): Int {
		return DEFAULT_PAGE_SIZE
	}
	
	@OptIn(ExperimentalPagingApi::class)
	fun getPinnedPostPagingData(
		targetId: String,
		targetType: String,
		placement: String? = null,
		sortByOptions: AmityPinSortByOptions,
	): Flowable<PagingData<AmityPinnedPost>> {
		val pagerCreator = DynamicQueryStreamPagerCreator(
			pagingConfig = PagingConfig(
				pageSize = getDefaultPageSize(),
				enablePlaceholders = false
			),
			dynamicQueryStreamMediator = PinnedPostMediator(
				targetId = targetId,
				targetType = targetType,
				placement = placement,
			),
			pagingSourceFactory = {
				PinLocalDataStore().getPinnedPostPagingSource(
					targetId = targetId,
					targetType = targetType,
					placement = placement,
				)
			},
			modelMapper = PinnedPostModelMapper()
		)
		return pagerCreator.create().toRx3()
	}
}

