package com.amity.socialcloud.sdk.api.chat.message.update

import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.ekoapp.ekosdk.internal.usecase.message.MessageUpdateUseCase
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Completable

abstract class AmityMessageUpdate(private val messageId: String) {
    internal abstract fun getData(): JsonObject?
    internal abstract fun getTags(): AmityTags?
    internal abstract fun getMetadata(): JsonObject?
    internal abstract fun getMentionees(): List<AmityMentioneeTarget>?

    fun apply(): Completable {
        return MessageUpdateUseCase().execute(
            messageId,
            getData(),
            getTags(),
            getMetadata(),
            getMentionees()
        )
    }
}