package com.amity.socialcloud.sdk.core.data.mention

import com.amity.socialcloud.sdk.core.mention.AmityMentionType
import com.amity.socialcloud.sdk.helper.core.mention.AmityMentionee
import com.ekoapp.ekosdk.internal.api.dto.EkoMentioneesDto


class MentioneeModelMapper {

    fun map(dtos : List<EkoMentioneesDto>) : List<AmityMentionee> {
        val mentionees = mutableListOf<AmityMentionee>()
        dtos.forEach { dtoItem ->
            if (AmityMentionType.enumOf(dtoItem.type) == AmityMentionType.USER) {
                dtoItem.userIds?.map { userId ->
                    mentionees.add(AmityMentionee.USER(userId, null))
                }
            }
        }
        return mentionees
    }
}