package com.amity.socialcloud.sdk.chat.domain.channel

import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import com.amity.socialcloud.sdk.chat.domain.channel.ChannelComposerUseCase
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.model.chat.channel.ChannelCreateOption
import io.reactivex.rxjava3.core.Single

internal class CreateConversationWithUserIdsUseCase {

    fun execute(option: ChannelCreateOption): Single<AmityChannel> {
        return ChannelRepository().createConversationChannel(option)
            .map {
                ChannelComposerUseCase().execute(it)
            }
    }

}