package com.amity.socialcloud.sdk.core.data.pin

import androidx.paging.PagingSource
import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.data.dao.PinDao
import com.ekoapp.ekosdk.internal.data.model.PinEntity
import io.reactivex.rxjava3.core.Completable

internal class PinLocalDataStore {
    
    fun getPinnedPostPagingSource(
        targetId: String,
        targetType: String,
        placement: String? = null,
    ): PagingSource<Int, PinEntity> {
        return UserDatabase.get().pinPagingDao().getPinnedPostPagingSource(
            targetId = targetId,
            targetType = targetType,
            placement = placement,
        )
    }

    fun savePinnedPost(
        pinnedPosts: List<PinEntity>
    ): Completable {
        return Completable.fromAction {
            val dao: PinDao = UserDatabase.get().pinDao()
            dao.save(pinnedPosts)
        }
    }
}