package com.ekoapp.ekosdk.internal.usecase.message

import com.amity.socialcloud.sdk.chat.data.message.MessageRepository
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage
import com.amity.socialcloud.sdk.api.chat.message.query.AmityMessageQuerySortOption
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.ekoapp.ekosdk.internal.repository.comment.CommentLoadResult
import io.reactivex.rxjava3.core.Single

internal class MessageManualLoadWithTokenUsecase {

    fun execute(
        channelId: String,
        sortOption: AmityMessageQuerySortOption,
        parentId: String?,
        isFilterByParentId: Boolean,
        isDeleted: Boolean?,
        includingTags: AmityTags,
        excludingTags: AmityTags,
        type: AmityMessage.DataType?,
        token: String
    ): Single<CommentLoadResult> {
        return MessageRepository().loadMessages(
            channelId,
            sortOption,
            parentId,
            isFilterByParentId,
            isDeleted,
            includingTags,
            excludingTags,
            type?.apiKey,
            token
        )
    }

}