package com.ekoapp.ekosdk.internal.keycreator

internal class PinKeyCreator(
	val targetId: String,
	val targetType: String,
	val placement: String? = null,
) : DynamicQueryStreamKeyCreator {
	
	override fun toMap(): Map<String, Any> {
		return mapOf(
			"targetId" to targetId,
			"targetType" to targetType,
			"placement" to (placement ?: ""),
		)
	}
	
	override fun getFilterQuery(): String {
		return " pin.targetId = '$targetId' "
	}
}