/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.social.post;

import androidx.paging.PagingData;
import com.amity.socialcloud.sdk.api.core.ExperimentalAmityApi;
import com.amity.socialcloud.sdk.api.social.AmitySocialClient;
import com.amity.socialcloud.sdk.api.social.comment.query.AmityCommentQuery;
import com.amity.socialcloud.sdk.api.social.post.create.target.AmityPostCreationTarget;
import com.amity.socialcloud.sdk.api.social.post.query.AmityPostQueryTarget;
import com.amity.socialcloud.sdk.api.social.post.reaction.AmityPostReactionQuery;
import com.amity.socialcloud.sdk.api.social.post.review.AmityPostReviewer;
import com.amity.socialcloud.sdk.api.social.post.update.AmityPostUpdate;
import com.amity.socialcloud.sdk.model.core.file.AmityFile;
import com.amity.socialcloud.sdk.model.core.file.AmityImage;
import com.amity.socialcloud.sdk.model.core.file.AmityVideo;
import com.amity.socialcloud.sdk.model.core.pin.AmityPinSortByOptions;
import com.amity.socialcloud.sdk.model.core.pin.AmityPinnedPost;
import com.amity.socialcloud.sdk.model.social.post.AmityPost;
import com.amity.socialcloud.sdk.social.domain.post.create.CustomPostCreateUseCase;
import com.amity.socialcloud.sdk.social.domain.post.create.FilePostCreateUseCase;
import com.amity.socialcloud.sdk.social.domain.post.create.ImagePostCreateUseCase;
import com.amity.socialcloud.sdk.social.domain.post.create.LiveStreamPostCreateUseCase;
import com.amity.socialcloud.sdk.social.domain.post.create.PollPostCreateUseCase;
import com.amity.socialcloud.sdk.social.domain.post.create.TextPostCreateUseCase;
import com.amity.socialcloud.sdk.social.domain.post.create.VideoPostCreateUseCase;
import com.amity.socialcloud.sdk.social.domain.post.flag.IsPostFlaggedByMeUseCase;
import com.amity.socialcloud.sdk.social.domain.post.getbyids.PostGetByIdsUseCase;
import com.amity.socialcloud.sdk.social.domain.post.update.PostEditUseCase;
import com.ekoapp.ekosdk.internal.usecase.post.FlagPostUseCase;
import com.ekoapp.ekosdk.internal.usecase.post.PinnedPostQueryUseCase;
import com.ekoapp.ekosdk.internal.usecase.post.PostApproveUseCase;
import com.ekoapp.ekosdk.internal.usecase.post.PostDeclineUseCase;
import com.ekoapp.ekosdk.internal.usecase.post.PostDeleteUseCase;
import com.ekoapp.ekosdk.internal.usecase.post.PostLiveObjectUseCase;
import com.ekoapp.ekosdk.internal.usecase.post.UnFlagPostUseCase;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006JB\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0011JJ\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\b\b\u0002\u0010\u0015\u001a\u00020\u00062\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0011JJ\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00112\b\b\u0002\u0010\u0015\u001a\u00020\u00062\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0011JD\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00062\b\b\u0002\u0010\u0015\u001a\u00020\u00062\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0011JD\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00062\b\b\u0002\u0010\u0015\u001a\u00020\u00062\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0011J\b\u0010\u001d\u001a\u00020\u001eH\u0007J:\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00062\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0011JJ\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00112\b\b\u0002\u0010\u0015\u001a\u00020\u00062\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0011J\u000e\u0010#\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J4\u0010$\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0011J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010'\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010(\u001a\u00020)2\u0006\u0010\u0005\u001a\u00020\u0006J0\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0,0+2\u0006\u0010.\u001a\u00020\u00062\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u00100\u001a\u000201J\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020\t0+2\u0006\u0010\u0005\u001a\u00020\u0006J \u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t040+2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011J\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u0002092\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010:\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010=\u001a\u00020>2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u000e\u0010?\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010@\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J6\u0010A\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0011H\u0007J\u0010\u0010B\u001a\u00020&2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006C"}, d2={"Lcom/amity/socialcloud/sdk/api/social/post/AmityPostRepository;", "", "()V", "approvePost", "Lio/reactivex/rxjava3/core/Completable;", "postId", "", "createCustomPost", "Lio/reactivex/rxjava3/core/Single;", "Lcom/amity/socialcloud/sdk/model/social/post/AmityPost;", "target", "Lcom/amity/socialcloud/sdk/model/social/post/AmityPost$Target;", "customDataType", "data", "Lcom/google/gson/JsonObject;", "metadata", "mentionUserIds", "", "createFilePost", "files", "Lcom/amity/socialcloud/sdk/model/core/file/AmityFile;", "text", "createImagePost", "images", "Lcom/amity/socialcloud/sdk/model/core/file/AmityImage;", "createLiveStreamPost", "streamId", "createPollPost", "pollId", "createPost", "Lcom/amity/socialcloud/sdk/api/social/post/create/target/AmityPostCreationTarget;", "createTextPost", "createVideoPost", "videos", "Lcom/amity/socialcloud/sdk/model/core/file/AmityVideo;", "declinePost", "editCustomPost", "editPost", "Lcom/amity/socialcloud/sdk/api/social/post/update/AmityPostUpdate$Builder;", "flagPost", "getComments", "Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentQuery$Builder;", "getPinnedPosts", "Lio/reactivex/rxjava3/core/Flowable;", "Landroidx/paging/PagingData;", "Lcom/amity/socialcloud/sdk/model/core/pin/AmityPinnedPost;", "communityId", "placement", "sortByOptions", "Lcom/amity/socialcloud/sdk/model/core/pin/AmityPinSortByOptions;", "getPost", "getPostByIds", "", "postIds", "getPosts", "Lcom/amity/socialcloud/sdk/api/social/post/query/AmityPostQueryTarget;", "getReactions", "Lcom/amity/socialcloud/sdk/api/social/post/reaction/AmityPostReactionQuery$Builder;", "hardDeletePost", "isPostFlaggedByMe", "", "reviewPost", "Lcom/amity/socialcloud/sdk/api/social/post/review/AmityPostReviewer;", "softDeletePost", "unflagPost", "updateCustomPost", "updatePost", "amity-sdk_release"})
public final class AmityPostRepository {
    @NotNull
    public final Flowable<AmityPost> getPost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new PostLiveObjectUseCase().execute(postId);
    }

    @NotNull
    public final Flowable<List<AmityPost>> getPostByIds(@NotNull Set<String> postIds) {
        Intrinsics.checkNotNullParameter(postIds, (String)"postIds");
        return new PostGetByIdsUseCase().execute(postIds);
    }

    @NotNull
    public final AmityPostQueryTarget getPosts() {
        return new AmityPostQueryTarget();
    }

    @Deprecated(message="Use dedicated post creation function with dedicated post type instead")
    @NotNull
    public final AmityPostCreationTarget createPost() {
        return new AmityPostCreationTarget();
    }

    @NotNull
    public final Single<AmityPost> createTextPost(@NotNull AmityPost.Target target, @NotNull String text, @Nullable JsonObject metadata, @Nullable Set<String> mentionUserIds) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Set<String> set = mentionUserIds;
        return new TextPostCreateUseCase().execute(target.getTargetType$amity_sdk_release().getApiKey(), target.getTargetId$amity_sdk_release(), text, metadata, set != null ? CollectionsKt.toList((Iterable)set) : null);
    }

    public static /* synthetic */ Single createTextPost$default(AmityPostRepository amityPostRepository, AmityPost.Target target, String string, JsonObject jsonObject, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            jsonObject = null;
        }
        if ((n & 8) != 0) {
            set = null;
        }
        return amityPostRepository.createTextPost(target, string, jsonObject, set);
    }

    @NotNull
    public final Single<AmityPost> createImagePost(@NotNull AmityPost.Target target, @NotNull Set<AmityImage> images, @NotNull String text, @Nullable JsonObject metadata, @Nullable Set<String> mentionUserIds) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(images, (String)"images");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Set<String> set = mentionUserIds;
        return new ImagePostCreateUseCase().execute(target.getTargetType$amity_sdk_release().getApiKey(), target.getTargetId$amity_sdk_release(), CollectionsKt.toList((Iterable)images), text, metadata, set != null ? CollectionsKt.toList((Iterable)set) : null);
    }

    public static /* synthetic */ Single createImagePost$default(AmityPostRepository amityPostRepository, AmityPost.Target target, Set set, String string, JsonObject jsonObject, Set set2, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        if ((n & 8) != 0) {
            jsonObject = null;
        }
        if ((n & 0x10) != 0) {
            set2 = null;
        }
        return amityPostRepository.createImagePost(target, set, string, jsonObject, set2);
    }

    @NotNull
    public final Single<AmityPost> createFilePost(@NotNull AmityPost.Target target, @NotNull Set<AmityFile> files, @NotNull String text, @Nullable JsonObject metadata, @Nullable Set<String> mentionUserIds) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Set<String> set = mentionUserIds;
        return new FilePostCreateUseCase().execute(target.getTargetType$amity_sdk_release().getApiKey(), target.getTargetId$amity_sdk_release(), CollectionsKt.toList((Iterable)files), text, metadata, set != null ? CollectionsKt.toList((Iterable)set) : null);
    }

    public static /* synthetic */ Single createFilePost$default(AmityPostRepository amityPostRepository, AmityPost.Target target, Set set, String string, JsonObject jsonObject, Set set2, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        if ((n & 8) != 0) {
            jsonObject = null;
        }
        if ((n & 0x10) != 0) {
            set2 = null;
        }
        return amityPostRepository.createFilePost(target, set, string, jsonObject, set2);
    }

    @NotNull
    public final Single<AmityPost> createVideoPost(@NotNull AmityPost.Target target, @NotNull Set<AmityVideo> videos, @NotNull String text, @Nullable JsonObject metadata, @Nullable Set<String> mentionUserIds) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(videos, (String)"videos");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Set<String> set = mentionUserIds;
        return new VideoPostCreateUseCase().execute(target.getTargetType$amity_sdk_release().getApiKey(), target.getTargetId$amity_sdk_release(), CollectionsKt.toList((Iterable)videos), text, metadata, set != null ? CollectionsKt.toList((Iterable)set) : null);
    }

    public static /* synthetic */ Single createVideoPost$default(AmityPostRepository amityPostRepository, AmityPost.Target target, Set set, String string, JsonObject jsonObject, Set set2, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        if ((n & 8) != 0) {
            jsonObject = null;
        }
        if ((n & 0x10) != 0) {
            set2 = null;
        }
        return amityPostRepository.createVideoPost(target, set, string, jsonObject, set2);
    }

    @NotNull
    public final Single<AmityPost> createPollPost(@NotNull AmityPost.Target target, @NotNull String pollId, @NotNull String text, @Nullable JsonObject metadata, @Nullable Set<String> mentionUserIds) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)pollId, (String)"pollId");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Set<String> set = mentionUserIds;
        return new PollPostCreateUseCase().execute(target.getTargetType$amity_sdk_release().getApiKey(), target.getTargetId$amity_sdk_release(), pollId, text, metadata, set != null ? CollectionsKt.toList((Iterable)set) : null);
    }

    public static /* synthetic */ Single createPollPost$default(AmityPostRepository amityPostRepository, AmityPost.Target target, String string, String string2, JsonObject jsonObject, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            jsonObject = null;
        }
        if ((n & 0x10) != 0) {
            set = null;
        }
        return amityPostRepository.createPollPost(target, string, string2, jsonObject, set);
    }

    @NotNull
    public final Single<AmityPost> createLiveStreamPost(@NotNull AmityPost.Target target, @NotNull String streamId, @NotNull String text, @Nullable JsonObject metadata, @Nullable Set<String> mentionUserIds) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Set<String> set = mentionUserIds;
        return new LiveStreamPostCreateUseCase().execute(target.getTargetType$amity_sdk_release().getApiKey(), target.getTargetId$amity_sdk_release(), streamId, text, metadata, set != null ? CollectionsKt.toList((Iterable)set) : null);
    }

    public static /* synthetic */ Single createLiveStreamPost$default(AmityPostRepository amityPostRepository, AmityPost.Target target, String string, String string2, JsonObject jsonObject, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            jsonObject = null;
        }
        if ((n & 0x10) != 0) {
            set = null;
        }
        return amityPostRepository.createLiveStreamPost(target, string, string2, jsonObject, set);
    }

    @NotNull
    public final Single<AmityPost> createCustomPost(@NotNull AmityPost.Target target, @NotNull String customDataType, @NotNull JsonObject data, @Nullable JsonObject metadata, @Nullable Set<String> mentionUserIds) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)customDataType, (String)"customDataType");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Set<String> set = mentionUserIds;
        return new CustomPostCreateUseCase().execute(target.getTargetType$amity_sdk_release().getApiKey(), target.getTargetId$amity_sdk_release(), new AmityPost.DataType.CUSTOM(customDataType), data, metadata, set != null ? CollectionsKt.toList((Iterable)set) : null);
    }

    public static /* synthetic */ Single createCustomPost$default(AmityPostRepository amityPostRepository, AmityPost.Target target, String string, JsonObject jsonObject, JsonObject jsonObject2, Set set, int n, Object object) {
        if ((n & 8) != 0) {
            jsonObject2 = null;
        }
        if ((n & 0x10) != 0) {
            set = null;
        }
        return amityPostRepository.createCustomPost(target, string, jsonObject, jsonObject2, set);
    }

    @NotNull
    public final AmityPostUpdate.Builder editPost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new AmityPostUpdate.Builder(postId);
    }

    @Deprecated(message="Use editPost(postId: String) instead")
    @NotNull
    public final AmityPostUpdate.Builder updatePost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return this.editPost(postId);
    }

    @NotNull
    public final Completable editCustomPost(@NotNull String postId, @NotNull JsonObject data, @Nullable JsonObject metadata, @Nullable Set<String> mentionUserIds) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Set<String> set = mentionUserIds;
        return PostEditUseCase.execute$default(new PostEditUseCase(), postId, data, metadata, set != null ? CollectionsKt.toList((Iterable)set) : null, null, 16, null);
    }

    public static /* synthetic */ Completable editCustomPost$default(AmityPostRepository amityPostRepository, String string, JsonObject jsonObject, JsonObject jsonObject2, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            jsonObject2 = null;
        }
        if ((n & 8) != 0) {
            set = null;
        }
        return amityPostRepository.editCustomPost(string, jsonObject, jsonObject2, set);
    }

    @Deprecated(message="Use editCustomPost(...) instead")
    @NotNull
    public final Completable updateCustomPost(@NotNull String postId, @NotNull JsonObject data, @Nullable JsonObject metadata, @Nullable Set<String> mentionUserIds) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.editCustomPost(postId, data, metadata, mentionUserIds);
    }

    public static /* synthetic */ Completable updateCustomPost$default(AmityPostRepository amityPostRepository, String string, JsonObject jsonObject, JsonObject jsonObject2, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            jsonObject2 = null;
        }
        if ((n & 8) != 0) {
            set = null;
        }
        return amityPostRepository.updateCustomPost(string, jsonObject, jsonObject2, set);
    }

    @NotNull
    public final Completable softDeletePost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new PostDeleteUseCase().execute(postId, false);
    }

    @NotNull
    public final Completable hardDeletePost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new PostDeleteUseCase().execute(postId, true);
    }

    @Deprecated(message="Use approvePost() or declinePost() instead")
    @NotNull
    public final AmityPostReviewer reviewPost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new AmityPostReviewer(postId);
    }

    @NotNull
    public final AmityPostReactionQuery.Builder getReactions(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new AmityPostReactionQuery.Builder(postId);
    }

    @NotNull
    public final AmityCommentQuery.Builder getComments(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return AmitySocialClient.INSTANCE.newCommentRepository().getComments().post(postId);
    }

    @NotNull
    public final Completable approvePost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new PostApproveUseCase().execute(postId);
    }

    @NotNull
    public final Completable declinePost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new PostDeclineUseCase().execute(postId);
    }

    @NotNull
    public final Completable flagPost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new FlagPostUseCase().execute(postId);
    }

    @NotNull
    public final Completable unflagPost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new UnFlagPostUseCase().execute(postId);
    }

    @ExperimentalAmityApi
    @NotNull
    public final Single<Boolean> isPostFlaggedByMe(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Single single = Single.fromCallable(() -> AmityPostRepository.isPostFlaggedByMe$lambda$0(postId));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"fromCallable { IsPostFla\u2026eCase().execute(postId) }");
        return single;
    }

    @NotNull
    public final Flowable<PagingData<AmityPinnedPost>> getPinnedPosts(@NotNull String communityId, @Nullable String placement, @NotNull AmityPinSortByOptions sortByOptions) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortByOptions), (String)"sortByOptions");
        return new PinnedPostQueryUseCase().execute(communityId, placement, sortByOptions);
    }

    public static /* synthetic */ Flowable getPinnedPosts$default(AmityPostRepository amityPostRepository, String string, String string2, AmityPinSortByOptions amityPinSortByOptions, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            amityPinSortByOptions = AmityPinSortByOptions.lastPinned;
        }
        return amityPostRepository.getPinnedPosts(string, string2, amityPinSortByOptions);
    }

    private static final Boolean isPostFlaggedByMe$lambda$0(String $postId) {
        Intrinsics.checkNotNullParameter((Object)$postId, (String)"$postId");
        return new IsPostFlaggedByMeUseCase().execute($postId);
    }
}

