package com.amity.socialcloud.sdk.core.data.pin

import com.ekoapp.ekosdk.internal.api.dto.PinnedPostQueryDto
import io.reactivex.rxjava3.core.Single
import retrofit2.http.GET
import retrofit2.http.Path
import retrofit2.http.Query

interface PinApi {
    @GET("api/v1/pinned-posts/communities/{communityId}")
    fun queryPinPost(
        @Path("communityId") communityId: String,
    ): Single<PinnedPostQueryDto>

    @GET("api/v1/pinned-posts/communities/{communityId}/{placement}")
    fun queryPinPostWithPlacement(
        @Path("communityId") communityId: String,
        @Path("placement") placement: String,
    ): Single<PinnedPostQueryDto>
}