package com.amity.socialcloud.sdk.core.data.follow.paging

import com.amity.socialcloud.sdk.model.core.follow.AmityFollowStatus
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator

class BlockedKeyCreator(
    private val userId: String
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "sourceUserId" to userId
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement()
    }

    private fun getConditionStatement(): String {
        //reference filter
        val userIdFilterStatement = "user_follow.sourceUserId = '$userId'"
        //follow status filter
        val followStatusFilterStatement =
            " and user_follow.status = '${AmityFollowStatus.BLOCKED.apiKey}'"
        val deletedUserFilterStatement =
            " and user_follow.targetUserId IN (SELECT userId from user where isDeleted = 0)"
        return userIdFilterStatement +
                followStatusFilterStatement +
                deletedUserFilterStatement
    }
}