package com.ekoapp.ekosdk.internal.api.event

import com.ekoapp.ekosdk.internal.util.Threads.isUiThread
import com.amity.socialcloud.sdk.log.AmityLog.w
import com.amity.socialcloud.sdk.log.AmityLog.i
import com.amity.socialcloud.sdk.log.AmityLog
import io.socket.emitter.Emitter
import java.util.*

abstract class SocketEventListener : Emitter.Listener {
	abstract val event: String
	override fun call(vararg args: Any) {
		onEvent(event, *args)
	}
	
	protected open fun onEvent(event: String, vararg args: Any) {
		val isMainThread = isUiThread
		val msg = "onEvent(main thread: $isMainThread): $event"
		if (isMainThread) {
			w(msg)
		} else {
			i("$msg args: ${args.contentDeepToString()}")
		}
	}
}