package com.amity.socialcloud.sdk.social.data.story

import com.amity.socialcloud.sdk.api.social.story.AmityStorySortOption
import com.amity.socialcloud.sdk.model.social.story.AmityStory
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator
import org.joda.time.DateTime


class StoryKeyCreator(
    private val targetType: AmityStory.TargetType,
    private val targetId: String,
    private val sortOption: AmityStorySortOption
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "targetId" to targetId,
            "targetType" to targetType.apiKey,
            "sortOption" to sortOption.apiKey
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement(
            targetType = targetType.apiKey,
            targetId = targetId
        )
    }

    private fun getConditionStatement(
        targetType: String,
        targetId: String,
    ): String {
        val now = DateTime.now().millis

        val filterStatement = "story.targetType = '${targetType}'" +
                " and story.targetId = '$targetId'" +
                " and story.isDeleted = 0" +
                " and story.expiresAt > '$now'"

        return filterStatement
    }


}