package com.amity.socialcloud.sdk.social.data.community.membership.paging

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.api.social.member.query.AmityCommunityMembershipSortOption
import com.amity.socialcloud.sdk.model.core.role.AmityRoles
import com.amity.socialcloud.sdk.model.social.member.AmityCommunityMembership
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.entity.CommunityMembershipEntity
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao

@Dao
internal interface CommunityMemberDynamicQueryPagingDao :
    DynamicQueryStreamPagingDao<CommunityMembershipEntity> {

    @RawQuery(observedEntities = [CommunityMembershipEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, CommunityMembershipEntity>

    fun queryCommunityMembership(
        communityId: String,
        roles: AmityRoles,
        filters: List<AmityCommunityMembership>?,
        sortBy: AmityCommunityMembershipSortOption,
    ): PagingSource<Int, CommunityMembershipEntity> {
        val sortColumn = when (sortBy) {
            AmityCommunityMembershipSortOption.DISPLAY_NAME -> null
            AmityCommunityMembershipSortOption.FIRST_CREATED -> "createdAt"
            AmityCommunityMembershipSortOption.LAST_CREATED -> "createdAt"
        }
        val order = when (sortBy) {
            AmityCommunityMembershipSortOption.DISPLAY_NAME -> AmityPagingDao.Order.ASC
            AmityCommunityMembershipSortOption.FIRST_CREATED -> AmityPagingDao.Order.ASC
            AmityCommunityMembershipSortOption.LAST_CREATED -> AmityPagingDao.Order.DESC
        }
        val query = generateQueryStreamSQL(
            tableName = "community_membership",
            primaryKeyColumnName = "userId",
            additionalPrimaryKeys = mapOf("communityId" to communityId),
            sortColumn = sortColumn,
            dynamicQueryStreamKeyCreator = CommunityMemberDynamicQueryKeyCreator(
                communityId,
                roles,
                filters,
                sortBy
            ),
            nonce = AmityNonce.COMMUNITY_MEMBERSHIP,
            order = order
        )
        return queryPagingData(query)
    }

}