package com.amity.socialcloud.sdk.core.data.ad

import androidx.room.Dao
import androidx.room.Query
import com.amity.socialcloud.sdk.entity.core.ad.AdsSettingsEntity
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao
import io.reactivex.rxjava3.core.Single


@Dao
abstract class AdsSettingsDao : EkoObjectDao<AdsSettingsEntity>() {
    @Query("DELETE from ads_settings")
    abstract override fun deleteAll()

    @Query("SELECT *" +
            " from ads_settings" +
            " where ads_settings.settingId = :id" +
            " LIMIT 1")
    abstract fun getByIdImpl(id: String): Single<List<AdsSettingsEntity>>
    fun getById(id: String): Single<List<AdsSettingsEntity>> {
        return getByIdImpl(id)
    }

    @Query("SELECT *" +
            " from ads_settings" +
            " where ads_settings.settingId = :id" +
            " LIMIT 1")
    abstract fun getByIdNowImpl(id: String): AdsSettingsEntity?
    override fun getByIdNow(id: String): AdsSettingsEntity? {
        return getByIdNowImpl(id)
    }

    @Query("SELECT *" +
            " from ads_settings" +
            " LIMIT 1")
    abstract fun getNowImpl(): AdsSettingsEntity?
    fun getNow(): AdsSettingsEntity? {
        return getNowImpl()
    }

    @Query("SELECT *" +
            " from ads_settings" +
            " where ads_settings.settingId IN (:ids)")
    abstract fun getByIdsNowImpl(ids: List<String>): List<AdsSettingsEntity>
    override fun getByIdsNow(ids: List<String>): List<AdsSettingsEntity> {
        return getByIdsNowImpl(ids)
    }
}