package com.amity.socialcloud.sdk.api.social.post.create.target

class AmityPostCreationTarget {

    /**
     * Indicates that the post will be created my feed
     * @return new instance of AmityUserPostQuery.Builder.
     */
    fun targetMe(): AmityMyFeedPostCreator {
        return AmityMyFeedPostCreator()
    }

    /**
     * Indicates which user feed the post will be created at
     * @param [userId] a userId
     * @return new instance of AmityUserPostQuery.Builder.
     */
    fun targetUser(userId: String): AmityUserFeedPostCreator {
        return AmityUserFeedPostCreator(userId)
    }

    /**
     * Indicates which community feed the post will be created at
     * @param [communityId] a communityId
     * @return new instance of AmityCommunityPostQuery.Builder.
     */
    fun targetCommunity(communityId: String): AmityCommunityFeedPostCreator {
        return AmityCommunityFeedPostCreator(communityId)
    }

}