package com.amity.socialcloud.sdk.chat.data.marker.user

import com.amity.socialcloud.sdk.common.EntityMapper
import com.ekoapp.ekosdk.internal.UserMarkerEntity
import com.ekoapp.ekosdk.internal.api.dto.UserMarkerDto
import org.joda.time.DateTime

internal class UserMarkerEntityMapper : EntityMapper<UserMarkerDto, UserMarkerEntity>() {

    override fun map(list: List<UserMarkerDto>): List<UserMarkerEntity> {
        return list.map { map(it) }
    }

    fun map(dto: UserMarkerDto) : UserMarkerEntity {
        return UserMarkerEntity().apply {
            userId = dto.userId
            unreadCount = dto.unreadCount
            hasMentioned = dto.hasMentioned
            createdAt = dto.createdAt ?: DateTime.now()
            updatedAt = dto.updatedAt ?: DateTime.now()
        }
    }

}