package com.ekoapp.ekosdk.internal.usecase.user

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.core.data.analytics.AnalyticsRepository
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.model.core.analytics.AmityViewedType
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class GetViewedUsersPagingDataUseCase {

    fun execute(
        viewableItemType: AmityViewedType,
        viewableItemId: String
    ): Flowable<PagingData<AmityUser>> {
        return AnalyticsRepository().getViewedUsers(
            viewableItemType = viewableItemType,
            viewableItemId = viewableItemId
        )
            .map { pagingData ->
                pagingData.map(Executors.newSingleThreadExecutor()) {
                    UserGetUseCase().execute(it.getUserId())!!
                }
            }
    }

}